/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.DataHandlerUtils;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FluidRecipeData
implements RecipeUpgradeData<FluidRecipeData> {
    private final List<IExtendedFluidTank> fluidTanks;

    FluidRecipeData(ListTag tanks) {
        int count = DataHandlerUtils.getMaxId(tanks, "Tank");
        this.fluidTanks = new ArrayList<IExtendedFluidTank>(count);
        for (int i = 0; i < count; ++i) {
            this.fluidTanks.add(BasicFluidTank.create(Integer.MAX_VALUE, null));
        }
        DataHandlerUtils.readContainers(this.fluidTanks, tanks);
    }

    private FluidRecipeData(List<IExtendedFluidTank> fluidTanks) {
        this.fluidTanks = fluidTanks;
    }

    @Override
    @Nullable
    public FluidRecipeData merge(FluidRecipeData other) {
        ArrayList<IExtendedFluidTank> allTanks = new ArrayList<IExtendedFluidTank>(this.fluidTanks);
        allTanks.addAll(other.fluidTanks);
        return new FluidRecipeData(allTanks);
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        if (this.fluidTanks.isEmpty()) {
            return true;
        }
        Item item = stack.m_41720_();
        Optional capability = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        final ArrayList<BasicFluidTank> fluidTanks = new ArrayList<BasicFluidTank>();
        if (capability.isPresent()) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)capability.get();
            i = 0;
            while (i < fluidHandler.getTanks()) {
                tank = i++;
                fluidTanks.add(BasicFluidTank.create(fluidHandler.getTankCapacity(tank), fluid -> fluidHandler.isFluidValid(tank, fluid), null));
            }
        } else if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            TileEntityMekanism tile = this.getTileFromBlock(blockItem.m_40614_());
            if (tile == null || !tile.handles(SubstanceType.FLUID)) {
                return false;
            }
            i = 0;
            while (i < tile.getTanks()) {
                tank = i++;
                fluidTanks.add(BasicFluidTank.create(tile.getTankCapacity(tank), fluid -> tile.isFluidValid(tank, (FluidStack)fluid), null));
            }
        } else {
            return false;
        }
        if (fluidTanks.isEmpty()) {
            return true;
        }
        IMekanismFluidHandler outputHandler = new IMekanismFluidHandler(){

            @Override
            @NotNull
            public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
                return fluidTanks;
            }

            @Override
            public void onContentsChanged() {
            }
        };
        boolean hasData = false;
        for (IExtendedFluidTank fluidTank : this.fluidTanks) {
            if (fluidTank.isEmpty()) continue;
            if (!outputHandler.insertFluid(fluidTank.getFluid(), Action.EXECUTE).isEmpty()) {
                return false;
            }
            hasData = true;
        }
        if (hasData) {
            ItemDataUtils.writeContainers(stack, "FluidTanks", fluidTanks);
        }
        return true;
    }
}

