/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.block.interfaces.ITypeBlock;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Attribute {
    default public void adjustProperties(BlockBehaviour.Properties props) {
    }

    public static boolean has(BlockState state, Class<? extends Attribute> type) {
        return Attribute.has(state.m_60734_(), type);
    }

    public static boolean has(Block block, Class<? extends Attribute> type) {
        ITypeBlock typeBlock;
        return block instanceof ITypeBlock && (typeBlock = (ITypeBlock)block).getType().has(type);
    }

    @Nullable
    public static <ATTRIBUTE extends Attribute> ATTRIBUTE get(BlockState state, Class<ATTRIBUTE> type) {
        return Attribute.get(state.m_60734_(), type);
    }

    @Nullable
    public static <ATTRIBUTE extends Attribute> ATTRIBUTE get(IBlockProvider blockProvider, Class<ATTRIBUTE> type) {
        return Attribute.get(blockProvider.getBlock(), type);
    }

    @Nullable
    public static <ATTRIBUTE extends Attribute> ATTRIBUTE get(Block block, Class<ATTRIBUTE> type) {
        ATTRIBUTE ATTRIBUTE;
        if (block instanceof ITypeBlock) {
            ITypeBlock typeBlock = (ITypeBlock)block;
            ATTRIBUTE = typeBlock.getType().get(type);
        } else {
            ATTRIBUTE = null;
        }
        return ATTRIBUTE;
    }

    public static Collection<Attribute> getAll(Block block) {
        Collection<Attribute> collection;
        if (block instanceof ITypeBlock) {
            ITypeBlock typeBlock = (ITypeBlock)block;
            collection = typeBlock.getType().getAll();
        } else {
            collection = Collections.emptyList();
        }
        return collection;
    }

    public static <ATTRIBUTE extends Attribute> boolean matches(Block block, Class<ATTRIBUTE> type, Predicate<? super ATTRIBUTE> checker) {
        ATTRIBUTE attribute = Attribute.get(block, type);
        return attribute != null && checker.test(attribute);
    }

    public static <ATTRIBUTE extends Attribute> void ifPresent(Block block, Class<ATTRIBUTE> type, Consumer<? super ATTRIBUTE> action) {
        ATTRIBUTE attribute = Attribute.get(block, type);
        if (attribute != null) {
            action.accept(attribute);
        }
    }

    @Nullable
    public static Direction getFacing(BlockState state) {
        AttributeStateFacing attr = Attribute.get(state, AttributeStateFacing.class);
        return attr == null ? null : attr.getDirection(state);
    }

    @Nullable
    public static BlockState setFacing(BlockState state, Direction facing) {
        AttributeStateFacing attr = Attribute.get(state, AttributeStateFacing.class);
        return attr == null ? null : attr.setDirection(state, facing);
    }

    public static boolean isActive(BlockState state) {
        AttributeStateActive attr = Attribute.get(state, AttributeStateActive.class);
        return attr != null && attr.isActive(state);
    }

    @NotNull
    public static BlockState setActive(BlockState state, boolean active) {
        AttributeStateActive attr = Attribute.get(state, AttributeStateActive.class);
        return attr == null ? state : attr.setActive(state, active);
    }

    @Nullable
    public static <TIER extends ITier> TIER getTier(IBlockProvider blockProvider, Class<TIER> tierClass) {
        return Attribute.getTier(blockProvider.getBlock(), tierClass);
    }

    @Nullable
    public static <TIER extends ITier> TIER getTier(Block block, Class<TIER> tierClass) {
        AttributeTier attr = Attribute.get(block, AttributeTier.class);
        return attr == null ? null : (TIER)attr.tier();
    }

    @Nullable
    public static BaseTier getBaseTier(Block block) {
        AttributeTier attr = Attribute.get(block, AttributeTier.class);
        return attr == null ? null : attr.tier().getBaseTier();
    }

    public static interface TileAttribute<TILE extends TileEntityMekanism>
    extends Attribute {
    }
}

