/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.palette;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import java.util.List;
import java.util.Locale;

public enum IdType {
    NONE(""),
    DIRECTIONAL(""),
    PILLAR(""),
    LIMITED_PILLAR(""),
    PANE_PILLAR(""),
    GIANT(""),
    CTM("ctm"),
    PANE_CTM("ctm"),
    CARPET_CTM("ctm");

    private final String suffix;

    private IdType(String suffix) {
        this.suffix = suffix;
    }

    public String suffix() {
        return this.suffix;
    }

    public String id() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public List<IntObjectPair<String>> getTextureIds() {
        return switch (this) {
            case PILLAR, LIMITED_PILLAR, PANE_PILLAR -> List.of(IntObjectPair.of((int)0, (Object)"self"), IntObjectPair.of((int)1, (Object)"top"), IntObjectPair.of((int)2, (Object)"center"), IntObjectPair.of((int)3, (Object)"bottom"));
            case CTM, CARPET_CTM, PANE_CTM -> List.of(IntObjectPair.of((int)0, (Object)"empty"), IntObjectPair.of((int)1, (Object)"vertical"), IntObjectPair.of((int)2, (Object)"horizontal"), IntObjectPair.of((int)3, (Object)"center"));
            case GIANT -> List.of(IntObjectPair.of((int)0, (Object)"1"), IntObjectPair.of((int)1, (Object)"2"), IntObjectPair.of((int)2, (Object)"3"), IntObjectPair.of((int)3, (Object)"4"));
            default -> List.of();
        };
    }

    public void addTextureInfo(JsonObject json) {
        if (this == GIANT) {
            json.addProperty("width", (Number)2);
            json.addProperty("height", (Number)2);
        }
    }

    public boolean isSpecial() {
        return this != NONE && this != DIRECTIONAL;
    }
}

