/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.sootychimneys.integration.create;

import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import io.github.mortuusars.sootychimneys.block.ChimneyBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ChimneyInteractionBehaviour
extends MovingInteractionBehaviour {
    public boolean handlePlayerInteraction(Player player, InteractionHand activeHand, BlockPos localPos, AbstractContraptionEntity contraptionEntity) {
        Contraption contraption = contraptionEntity.getContraption();
        ContraptionWorld contraptionLevel = contraption.getContraptionWorld();
        BlockState state = contraptionLevel.m_8055_(localPos);
        Block block = state.m_60734_();
        if (!(block instanceof ChimneyBlock)) {
            return false;
        }
        ChimneyBlock chimney = (ChimneyBlock)block;
        @Nullable MutablePair actor = contraption.getActorAt(localPos);
        boolean newBlockedValue = (Boolean)state.m_61143_((Property)ChimneyBlock.BLOCKED) == false;
        BlockState newState = (BlockState)contraptionLevel.m_8055_(localPos).m_61124_((Property)ChimneyBlock.BLOCKED, (Comparable)Boolean.valueOf(newBlockedValue));
        StructureTemplate.StructureBlockInfo structureBlockInfo = new StructureTemplate.StructureBlockInfo(localPos, newState, null);
        if (actor == null) {
            return false;
        }
        actor.setLeft((Object)structureBlockInfo);
        MovementContext context = (MovementContext)actor.getRight();
        context.state = newState;
        if (!contraptionLevel.f_46443_) {
            contraptionEntity.setBlock(localPos, structureBlockInfo);
            Vector3f particleOrigin = chimney.getSmokeProperties().getParticleOrigin();
            RandomSource random = player.m_9236_().m_213780_();
            Vec3 pos = context.position;
            player.m_9236_().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, newBlockedValue ? SoundEvents.f_12026_ : SoundEvents.f_12027_, SoundSource.BLOCKS, 0.8f, 0.85f + contraptionLevel.f_46441_.m_188501_() * 0.05f);
            for (int i = 0; i < random.m_188503_(5); ++i) {
                ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, pos.m_7096_() + (double)particleOrigin.x(), pos.m_7098_() + (double)particleOrigin.y() - 0.1, pos.m_7094_() + (double)particleOrigin.z(), 1, random.m_188583_() * 0.1, random.m_188583_() * 0.1, random.m_188583_() * 0.1, 0.0);
            }
        } else {
            String messageTranslationKey = "message.sootychimneys." + (newBlockedValue ? "blocked" : "open");
            player.m_5661_((Component)Component.m_237115_((String)messageTranslationKey), true);
        }
        return true;
    }
}

