/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.infrastructure;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class ShutterSpeed {
    public static final ShutterSpeed DEFAULT = new ShutterSpeed("60");
    private final String text;
    private final float valueMilliseconds;

    public ShutterSpeed(String shutterSpeed) {
        this.text = shutterSpeed;
        this.valueMilliseconds = this.parseMilliseconds(shutterSpeed);
        Preconditions.checkState((this.valueMilliseconds != -1.0f ? 1 : 0) != 0, (Object)(shutterSpeed + " is not valid. (format should be: '1/60', '60', '2\"')"));
        Preconditions.checkState((this.valueMilliseconds > 0.0f ? 1 : 0) != 0, (Object)"Shutter Speed cannot be 0 or smaller.");
    }

    private float parseMilliseconds(String shutterSpeed) {
        if ((shutterSpeed = shutterSpeed.trim()).contains("\"")) {
            return Integer.parseInt(shutterSpeed.replace("\"", "")) * 1000;
        }
        if (shutterSpeed.contains("1/")) {
            return 1.0f / (float)Integer.parseInt(shutterSpeed.replace("1/", "")) * 1000.0f;
        }
        return 1.0f / (float)Integer.parseInt(shutterSpeed) * 1000.0f;
    }

    public String getFormattedText() {
        if (this.getMilliseconds() < 999.0f && !this.text.startsWith("1/")) {
            return "1/" + this.text;
        }
        return this.text;
    }

    public float getMilliseconds() {
        return this.valueMilliseconds;
    }

    public int getTicks() {
        return Math.max(1, (int)(this.valueMilliseconds * 20.0f / 1000.0f));
    }

    public float getStopsDifference(ShutterSpeed relative) {
        return (float)(Math.log(this.valueMilliseconds / relative.getMilliseconds()) / Math.log(2.0));
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128359_("ShutterSpeed", this.text);
        return tag;
    }

    public static ShutterSpeed loadOrDefault(CompoundTag tag) {
        try {
            if (tag.m_128425_("ShutterSpeed", 8)) {
                String shutterSpeed = tag.m_128461_("ShutterSpeed");
                return new ShutterSpeed(shutterSpeed);
            }
        }
        catch (IllegalStateException e) {
            Exposure.LOGGER.error("Cannot load a shutter speed from tag: " + String.valueOf(e));
        }
        return DEFAULT;
    }

    public void toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.text);
    }

    public static ShutterSpeed fromBuffer(FriendlyByteBuf buffer) {
        return new ShutterSpeed(buffer.m_130277_());
    }

    public String toString() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShutterSpeed that = (ShutterSpeed)o;
        return Float.compare(that.valueMilliseconds, this.valueMilliseconds) == 0 && Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        return Objects.hash(this.text, Float.valueOf(this.valueMilliseconds));
    }
}

