/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import immersive_aircraft.Main;
import immersive_aircraft.client.gui.SlotRenderer;
import immersive_aircraft.entity.inventory.slots.SlotDescription;
import immersive_aircraft.screen.VehicleScreenHandler;
import immersive_aircraft.util.Rect2iCommon;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class VehicleScreen
extends AbstractContainerScreen<VehicleScreenHandler> {
    private static final ResourceLocation TEXTURE = Main.locate("textures/gui/container/inventory.png");
    public static final int TITLE_HEIGHT = 10;
    public static final int BASE_HEIGHT = 86;
    public int containerSize;

    public VehicleScreen(VehicleScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.containerSize = handler.getVehicle().getInventoryDescription().getHeight();
        this.f_97727_ = 86 + this.containerSize + 20;
        this.f_97731_ = this.containerSize + 10;
    }

    protected void m_7286_(@NotNull GuiGraphics context, float delta, int mouseX, int mouseY) {
    }

    protected void drawRectangle(GuiGraphics context, int x, int y, int h, int w) {
        context.m_280163_(TEXTURE, x, y, 176.0f, 0.0f, 16, 16, 512, 256);
        context.m_280163_(TEXTURE, x + w - 16, y, 208.0f, 0.0f, 16, 16, 512, 256);
        context.m_280163_(TEXTURE, x + w - 16, y + h - 16, 208.0f, 32.0f, 16, 16, 512, 256);
        context.m_280163_(TEXTURE, x, y + h - 16, 176.0f, 32.0f, 16, 16, 512, 256);
        context.m_280411_(TEXTURE, x + 16, y, w - 32, 16, 192.0f, 0.0f, 16, 16, 512, 256);
        context.m_280411_(TEXTURE, x + 16, y + h - 16, w - 32, 16, 192.0f, 32.0f, 16, 16, 512, 256);
        context.m_280411_(TEXTURE, x, y + 16, 16, h - 32, 176.0f, 16.0f, 16, 16, 512, 256);
        context.m_280411_(TEXTURE, x + w - 16, y + 16, 16, h - 32, 208.0f, 16.0f, 16, 16, 512, 256);
        context.m_280411_(TEXTURE, x + 16, y + 16, w - 32, h - 32, 192.0f, 16.0f, 16, 16, 512, 256);
    }

    protected void drawCustomBackground(GuiGraphics context) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.containerSize + 20, 512, 256);
        context.m_280163_(TEXTURE, this.f_97735_, this.f_97736_ + this.containerSize + 20 - 4, 0.0f, 136.0f, this.f_97726_, 86, 512, 256);
        for (Rect2iCommon rectangle : ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getRectangles()) {
            this.drawRectangle(context, this.f_97735_ + rectangle.getX(), this.f_97736_ + rectangle.getY(), rectangle.getHeight(), rectangle.getWidth());
        }
    }

    public void drawImage(GuiGraphics context, int x, int y, int u, int v, int w, int h) {
        context.m_280163_(TEXTURE, x, y, (float)u, (float)v, w, h, 512, 256);
    }

    public void m_88315_(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        this.drawCustomBackground(context);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        for (SlotDescription slot : ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getSlots()) {
            SlotRenderer.get(slot.type()).render(this, context, slot, mouseX, mouseY, delta);
        }
        super.m_88315_(context, mouseX, mouseY, delta);
        if (this.f_97734_ != null && !this.f_97734_.m_6657_() && this.f_97734_.f_40218_ == ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventory()) {
            SlotDescription slot = ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getSlots().get(this.f_97734_.m_150661_());
            slot.getToolTip().ifPresent(tooltip -> context.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY));
        } else {
            this.m_280072_(context, mouseX, mouseY);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    protected boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        if (super.m_7467_(mouseX, mouseY, left, top, button)) {
            for (Rect2iCommon rectangle : ((VehicleScreenHandler)this.f_97732_).getVehicle().getInventoryDescription().getRectangles()) {
                if (!(mouseX > (double)(rectangle.getX() + this.f_97735_)) || !(mouseX < (double)(rectangle.getX() + rectangle.getWidth() + this.f_97735_)) || !(mouseY > (double)(rectangle.getY() + this.f_97736_)) || !(mouseY < (double)(rectangle.getY() + rectangle.getHeight() + this.f_97736_))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getX() {
        return this.f_97735_;
    }

    public int getY() {
        return this.f_97736_;
    }
}

