/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.compat.EndRemasteredCompat;
import einstein.subtle_effects.data.MobSkullShaderData;
import einstein.subtle_effects.data.MobSkullShaderReloadListener;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.mixin.client.GameRendererAccessor;
import einstein.subtle_effects.mixin.client.block.AbstractCauldronBlockAccessor;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedColor;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class Util {
    public static final int BREATH_DELAY = 60;
    public static final int SNORE_DELAY = 10;
    public static final int MAX_Z_COUNT = 3;
    public static final DustParticleOptions GLOWSTONE_DUST_PARTICLES = new DustParticleOptions(Vec3.m_82501_((int)16759902).m_252839_(), 1.0f);
    public static final ResourceLocation COLORLESS_RAIN_TEXTURE = SubtleEffects.loc("textures/environment/colorless_rain.png");
    public static final Gson GSON = new GsonBuilder().create();
    public static final ResourceLocation VANILLA_EYE = new ResourceLocation("ender_eye");

    public static void playClientSound(Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level != null && level.f_46443_) {
            level.m_6269_((Player)minecraft.f_91074_, entity, sound, source, volume, pitch);
        }
    }

    public static void playClientSound(BlockPos pos, SoundEvent sound, SoundSource source, float volume, float pitch) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level != null && level.f_46443_) {
            level.m_6263_((Player)minecraft.f_91074_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), sound, source, volume, pitch);
        }
    }

    public static boolean isSolidOrNotEmpty(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60804_((BlockGetter)level, pos) || !level.m_6425_(pos).m_76178_();
    }

    public static int getLightColor(int superLight) {
        return 0xF0 | superLight >> 16 & 0xFF0000;
    }

    public static void applyHelmetShader(ItemStack stack, CameraType cameraType) {
        if (!cameraType.m_90612_()) {
            return;
        }
        GameRenderer gameRenderer = Minecraft.m_91087_().f_91063_;
        for (MobSkullShaderData shaderData : MobSkullShaderReloadListener.MOB_SKULL_SHADERS.values()) {
            if (!shaderData.stackHolder().matches(stack)) continue;
            Util.loadShaderEffect(shaderData.shaderId(), gameRenderer);
            return;
        }
        gameRenderer.m_109086_();
    }

    private static void loadShaderEffect(ResourceLocation shaderId, GameRenderer gameRenderer) {
        PostChain effect = gameRenderer.m_109149_();
        if (effect == null || !effect.m_110022_().equals(shaderId.toString())) {
            ((GameRendererAccessor)gameRenderer).loadShaderEffect(shaderId);
        }
    }

    public static void setColorFromHex(Particle particle, int hexColor) {
        particle.m_107253_((float)(hexColor >> 16) / 255.0f, (float)(hexColor >> 8) / 255.0f, (float)hexColor / 255.0f);
    }

    public static boolean isChunkLoaded(Level level, double blockX, double blockZ) {
        return level.m_7726_().m_5563_(SectionPos.m_235865_((double)blockX), SectionPos.m_235865_((double)blockZ));
    }

    public static double getCauldronFillHeight(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof AbstractCauldronBlock) {
            AbstractCauldronBlock block2 = (AbstractCauldronBlock)block;
            return ((AbstractCauldronBlockAccessor)block2).getFillHeight(state);
        }
        return 0.0;
    }

    public static Fluid getCauldronFluid(BlockState state) {
        if (state.m_60713_(Blocks.f_152477_)) {
            return Fluids.f_76195_;
        }
        if (state.m_60713_(Blocks.f_152476_)) {
            return Fluids.f_76193_;
        }
        return Fluids.f_76191_;
    }

    public static ValidatedColor.ColorHolder getEyeColorHolder(Level level, BlockPos pos) {
        ValidatedColor.ColorHolder color;
        if (CompatHelper.IS_END_REMASTERED_LOADED.get().booleanValue() && (color = EndRemasteredCompat.getEyeColor(level, pos)) != null) {
            return color;
        }
        ValidatedColor.ColorHolder vanillaColor = (ValidatedColor.ColorHolder)ModConfigs.BLOCKS.eyeColors.get((Object)VANILLA_EYE);
        if (vanillaColor != null) {
            return vanillaColor;
        }
        return Util.toColorHolder(0x7ABAAB);
    }

    public static ValidatedColor.ColorHolder toColorHolder(int color) {
        return new ValidatedColor.ColorHolder(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255, false);
    }
}

