/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers.entity_tickers.sleeping;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.tickers.entity_tickers.EntityTicker;
import einstein.subtle_effects.util.Util;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;

public class SleepingTicker<T extends LivingEntity>
extends EntityTicker<T> {
    private final SoundEvent snoreSound;
    private final float snoreVolume;
    private final int breathDelay;
    private final boolean doesSnore;
    private boolean firstSleepTick = true;
    private boolean isFirstBreath = true;
    private int snoreStartDelay = 0;
    private int delayTimer = 0;
    private int breatheTimer = 0;
    private int snoreTimer = 0;
    private int zCount = 0;

    public SleepingTicker(T entity) {
        this(entity, true, 60, null, 0.0f);
    }

    public SleepingTicker(T entity, boolean doesSnore, int breathDelay, SoundEvent snoreSound, float snoreVolume) {
        super(entity);
        this.doesSnore = doesSnore;
        this.snoreVolume = snoreVolume;
        this.snoreSound = snoreSound;
        this.breathDelay = breathDelay;
    }

    @Override
    public void entityTick() {
        if (this.isSleeping()) {
            if (this.firstSleepTick) {
                this.snoreStartDelay = this.shouldDelay() ? 60 + this.random.m_188503_(40) : 0;
                this.firstSleepTick = false;
                return;
            }
            if (this.delayTimer < this.snoreStartDelay) {
                ++this.delayTimer;
                return;
            }
            if (!this.isFirstBreath && this.breatheTimer < this.breathDelay) {
                ++this.breatheTimer;
                return;
            }
            if (this.snoreTimer >= 10) {
                if (this.doesSnore && !((LivingEntity)this.entity).m_20067_() && this.zCount <= 0 && this.snoreSound != null) {
                    Util.playClientSound(this.entity, this.snoreSound, SoundSource.NEUTRAL, this.snoreVolume, ((LivingEntity)this.entity).m_6100_());
                }
                this.snoreTimer = 0;
                ++this.zCount;
                if (this.particleConfigEnabled() && (!ModConfigs.ENTITIES.sleeping.displaySleepingZsOnlyWhenSnoring || this.doesSnore)) {
                    this.level.m_7106_(this.getParticle(), ((LivingEntity)this.entity).m_20185_(), ((LivingEntity)this.entity).m_20186_() + 0.5, ((LivingEntity)this.entity).m_20189_(), 0.0, 0.0, 0.0);
                }
                if (this.zCount >= 3) {
                    this.zCount = 0;
                    this.breatheTimer = 0;
                    this.isFirstBreath = false;
                }
            }
            if (this.snoreTimer < 10) {
                ++this.snoreTimer;
            }
            return;
        }
        this.firstSleepTick = true;
        this.isFirstBreath = true;
        this.snoreStartDelay = 0;
        this.delayTimer = 0;
        this.breatheTimer = 0;
        this.snoreTimer = 0;
        this.zCount = 0;
    }

    protected boolean isSleeping() {
        return ((LivingEntity)this.entity).m_5803_();
    }

    protected ParticleOptions getParticle() {
        return (ParticleOptions)ModParticles.SNORING.get();
    }

    protected boolean shouldDelay() {
        return true;
    }

    protected boolean particleConfigEnabled() {
        return ModConfigs.ENTITIES.sleeping.otherMobsHaveSleepingZs;
    }

    protected static boolean doesEntitySnore(LivingEntity entity, double chance) {
        UUID uuid = entity.m_20148_();
        return Double.parseDouble("0." + Math.abs(uuid.hashCode())) < chance;
    }
}

