/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.biome_particles.BiomeParticleManager;
import einstein.subtle_effects.configs.CommandBlockSpawnType;
import einstein.subtle_effects.configs.ModBlockConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.particle.option.PositionParticleOptions;
import einstein.subtle_effects.tickers.FlameGeyserTicker;
import einstein.subtle_effects.tickers.TickerManager;
import einstein.subtle_effects.util.AmethystClusterBlockAccessor;
import einstein.subtle_effects.util.BlockTickerProvider;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModBlockTickers {
    public static final Map<Block, BlockTickerProvider> REGISTERED = new HashMap<Block, BlockTickerProvider>();
    public static final Map<Predicate<BlockState>, BlockTickerProvider> REGISTERED_SPECIAL = new HashMap<Predicate<BlockState>, BlockTickerProvider>();

    public static void init() {
        REGISTERED.clear();
        REGISTERED_SPECIAL.clear();
        ModBlockTickers.register(Blocks.f_50330_, () -> ModConfigs.BLOCKS.redstoneBlockDust, (BlockState state, Level level, BlockPos pos, RandomSource random) -> ParticleSpawnUtil.spawnParticlesAroundBlock((ParticleOptions)DustParticleOptions.f_123656_, level, pos, random, ModConfigs.BLOCKS.redstoneBlockDustDensity.getPerSideChance()));
        ModBlockTickers.register(Blocks.f_50141_, () -> ModConfigs.BLOCKS.glowstoneBlockDustDisplayType != ModBlockConfigs.GlowstoneDustDisplayType.OFF, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            if (ModConfigs.BLOCKS.glowstoneBlockDustDisplayType.equals((Object)ModBlockConfigs.GlowstoneDustDisplayType.NETHER_ONLY) && !level.m_46472_().equals((Object)Level.f_46429_)) {
                return;
            }
            ParticleSpawnUtil.spawnParticlesAroundBlock((ParticleOptions)Util.GLOWSTONE_DUST_PARTICLES, level, pos, random, ModConfigs.BLOCKS.glowstoneBlockDustDensity.getPerSideChance());
        });
        ModBlockTickers.register(Blocks.f_271329_, () -> ModConfigs.BLOCKS.torchflowerSmoke.isEnabled() || ModConfigs.BLOCKS.torchflowerFlames, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            Vec3 center = state.m_60808_((BlockGetter)level, pos).m_83215_().m_82399_();
            Vec3 offsetPos = new Vec3((double)pos.m_123341_() + center.m_7096_(), (double)pos.m_123342_() + center.m_7098_() + 0.3, (double)pos.m_123343_() + center.m_7094_());
            if (ModConfigs.BLOCKS.torchflowerSmoke.isEnabled() && random.m_188503_(3) == 0) {
                level.m_7106_(ModConfigs.BLOCKS.torchflowerSmoke.getParticle().get(), offsetPos.m_7096_(), offsetPos.m_7098_(), offsetPos.m_7094_(), 0.0, 0.0, 0.0);
            }
            if (ModConfigs.BLOCKS.torchflowerFlames && random.m_188503_(5) == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, offsetPos.m_7096_(), offsetPos.m_7098_(), offsetPos.m_7094_(), 0.0, 0.0, 0.0);
            }
        });
        ModBlockTickers.register(Blocks.f_50260_, () -> ModConfigs.BLOCKS.dragonEggParticles, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            for (int i = 0; i < 3; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + 0.5 + 0.25 * (double)MathUtil.nextSign(random), (double)pos.m_123342_() + random.m_188500_(), (double)pos.m_123343_() + 0.5 + 0.25 * (double)MathUtil.nextSign(random), MathUtil.nextNonAbsDouble(random), (random.m_188500_() - 0.5) * 0.125, MathUtil.nextNonAbsDouble(random));
            }
        });
        ModBlockTickers.register(Blocks.f_152477_, () -> ModConfigs.BLOCKS.lavaCauldronEffects, (BlockState state, Level level, BlockPos pos, RandomSource random) -> ((LavaFluid.Source)Fluids.f_76195_).m_213811_(level, pos, (FluidState)Fluids.f_76195_.m_76145_().m_61124_((Property)BlockStateProperties.f_61434_, (Comparable)Boolean.valueOf(false)), random));
        ModBlockTickers.register(Blocks.f_50273_, () -> ModConfigs.BLOCKS.beaconParticlesDisplayType != ModBlockConfigs.BeaconParticlesDisplayType.OFF, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            BeaconBlockEntity beaconBlockEntity;
            List sections;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof BeaconBlockEntity && !(sections = (beaconBlockEntity = (BeaconBlockEntity)blockEntity).m_58702_()).isEmpty() && (sections.size() <= 1 || ModConfigs.BLOCKS.beaconParticlesDisplayType != ModBlockConfigs.BeaconParticlesDisplayType.NOT_COLORED)) {
                PositionParticleOptions options = new PositionParticleOptions(ModParticles.BEACON.get(), beaconBlockEntity.m_58899_());
                for (int i = 0; i < (Integer)ModConfigs.BLOCKS.beaconParticlesDensity.get(); ++i) {
                    level.m_7106_((ParticleOptions)options, (double)pos.m_123341_() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.3), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.3), 0.0, 0.0, 0.0);
                }
            }
        });
        ModBlockTickers.register(Blocks.f_50724_, () -> ModConfigs.BLOCKS.respawnAnchorParticles, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            Direction direction;
            if (random.m_188503_(5) == 0 && (direction = Direction.m_235672_((RandomSource)random)) != Direction.UP) {
                BlockPos relativePos = pos.m_121945_(direction);
                BlockState relativeState = level.m_8055_(relativePos);
                if (!state.m_60815_() || !relativeState.m_60783_((BlockGetter)level, relativePos, direction.m_122424_())) {
                    ParticleSpawnUtil.spawnParticlesOnSide((ParticleOptions)ParticleTypes.f_123786_, 0.1f, direction, level, pos, random, 0.0, 0.0, 0.0);
                }
            }
        });
        ModBlockTickers.register(Blocks.f_152476_, () -> ModConfigs.BLOCKS.steam.steamingWaterCauldron || ModConfigs.BLOCKS.steam.boilingWaterCauldron, (BlockState state, Level level, BlockPos pos, RandomSource random) -> ParticleSpawnUtil.spawnHeatedWaterParticles(level, pos, random, false, 0.5625 + (double)((Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue() * 0.1875, ModConfigs.BLOCKS.steam.steamingWaterCauldron, ModConfigs.BLOCKS.steam.boilingWaterCauldron));
        ModBlockTickers.register(Blocks.f_50446_, () -> ModConfigs.BLOCKS.endPortalParticles, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            for (int i = 0; i < 5; ++i) {
                level.m_7106_((ParticleOptions)ModParticles.END_PORTAL.get(), (double)(pos.m_123341_() + (random.m_188503_(3) - 1)) + random.m_188500_(), (double)(pos.m_123342_() + (random.m_188503_(3) - 1)) + random.m_188500_(), (double)(pos.m_123343_() + (random.m_188503_(3) - 1)) + random.m_188500_(), 0.0, 0.0, 0.0);
            }
        });
        ModBlockTickers.register((BlockState state) -> state.m_60734_() instanceof CampfireBlock && (Boolean)state.m_61143_((Property)CampfireBlock.f_51227_) != false, () -> ((Float)ModConfigs.BLOCKS.campfireSizzlingSoundVolume.get()).floatValue() > 0.0f, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            BlockEntity patt9089$temp = level.m_7702_(pos);
            if (patt9089$temp instanceof CampfireBlockEntity) {
                CampfireBlockEntity blockEntity = (CampfireBlockEntity)patt9089$temp;
                for (ItemStack stack : blockEntity.m_59065_()) {
                    if (stack.m_41619_() || random.m_188503_(5) != 0) continue;
                    Util.playClientSound(pos, ModSounds.CAMPFIRE_SIZZLE.get(), SoundSource.BLOCKS, Mth.m_216267_((RandomSource)random, (float)0.3f, (float)0.7f) * (((Float)ModConfigs.BLOCKS.campfireSizzlingSoundVolume.get()).floatValue() * 2.0f), Mth.m_216267_((RandomSource)random, (float)1.0f, (float)1.5f));
                }
            }
        });
        ModBlockTickers.register((BlockState state) -> state.m_60734_() instanceof CommandBlock, () -> ModConfigs.BLOCKS.commandBlockParticles != CommandBlockSpawnType.OFF, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            if (ModConfigs.BLOCKS.commandBlockParticles == CommandBlockSpawnType.NOT_CREATIVE && Minecraft.m_91087_().f_91074_.m_7500_()) {
                return;
            }
            ParticleSpawnUtil.spawnCmdBlockParticles(level, Vec3.m_82512_((Vec3i)pos), random, (direction, relativePos) -> !Util.isSolidOrNotEmpty(level, BlockPos.m_274446_((Position)relativePos)));
        });
        ModBlockTickers.register((BlockState state) -> state.m_60713_(Blocks.f_152490_) || state.m_60713_(Blocks.f_152491_), () -> ModConfigs.BLOCKS.amethystSparkleDisplayType == ModBlockConfigs.AmethystSparkleDisplayType.ON, (BlockState state, Level level, BlockPos pos, RandomSource random) -> ParticleSpawnUtil.spawnParticlesAroundBlock((ParticleOptions)ModParticles.AMETHYST_SPARKLE.get(), level, pos, random, 5));
        ModBlockTickers.register((BlockState state) -> state.m_60734_() instanceof AmethystClusterBlock, () -> ModConfigs.BLOCKS.amethystSparkleSounds, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            int chance;
            if (((AmethystClusterBlockAccessor)state.m_60734_()).subtleEffects$getHeight() >= 5.0f && (chance = random.m_188503_(100)) <= 5) {
                if (chance == 0) {
                    Util.playClientSound(pos, ModSounds.AMETHYST_CLUSTER_CHIME.get(), SoundSource.BLOCKS, Mth.m_216267_((RandomSource)random, (float)0.15f, (float)0.3f), 1.0f);
                    return;
                }
                Util.playClientSound(pos, SoundEvents.f_144243_, SoundSource.BLOCKS, Mth.m_216267_((RandomSource)random, (float)0.07f, (float)1.5f), Mth.m_216267_((RandomSource)random, (float)0.07f, (float)1.3f));
            }
        });
        ModBlockTickers.register((BlockState state) -> state.m_60713_(Blocks.f_152493_) || state.m_60713_(Blocks.f_152492_), () -> ModConfigs.BLOCKS.amethystSparkleDisplayType != ModBlockConfigs.AmethystSparkleDisplayType.OFF, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            AmethystClusterBlockAccessor block = (AmethystClusterBlockAccessor)state.m_60734_();
            float height = block.subtleEffects$getHeight();
            if (height >= 5.0f && random.m_188503_(5) == 0) {
                float offset = block.subtleEffects$getAABBOffset() / 16.0f + 0.0625f;
                float pixelHeight = height / 16.0f;
                level.m_7106_((ParticleOptions)ModParticles.AMETHYST_SPARKLE.get(), (double)pos.m_123341_() + 0.5 + MathUtil.nextNonAbsDouble(random, offset), (double)((float)pos.m_123342_() + pixelHeight + pixelHeight / 2.0f), (double)pos.m_123343_() + 0.5 + MathUtil.nextNonAbsDouble(random, offset), 0.0, 0.0, 0.0);
            }
        });
        ModBlockTickers.register(Blocks.f_152471_, () -> ModConfigs.BLOCKS.floweringAzaleaPetals, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            BlockPos belowPos;
            BlockState belowState;
            if (random.m_188503_(10) == 0 && !Block.m_49918_((VoxelShape)(belowState = level.m_8055_(belowPos = pos.m_7495_())).m_60812_((BlockGetter)level, belowPos), (Direction)Direction.UP)) {
                ParticleUtils.m_272037_((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)((ParticleOptions)ModParticles.AZALEA_PETAL.get()));
            }
        });
        ModBlockTickers.register(Blocks.f_220855_, () -> ModConfigs.BLOCKS.sculkBlockSculkDust, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            if (random.m_188503_(20) == 0) {
                ParticleSpawnUtil.spawnParticlesAroundBlock((ParticleOptions)ModParticles.SCULK_DUST.get(), level, pos, random, 0);
            }
        });
        ModBlockTickers.register(Blocks.f_220856_, () -> ModConfigs.BLOCKS.sculkVeinSculkDust, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            if (random.m_188503_(30) == 0) {
                ParticleSpawnUtil.spawnParticlesAroundBlock((ParticleOptions)ModParticles.SCULK_DUST.get(), level, pos, random, -0.9375f, direction -> direction.m_122434_() != Direction.Axis.Y);
            }
        });
        ModBlockTickers.register(Blocks.f_276595_, () -> ModConfigs.BLOCKS.calibratedSculkSensorAmethystSparkle, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            if (random.m_188503_(SculkSensorBlock.m_154487_((BlockState)state) == SculkSensorPhase.ACTIVE ? 1 : 5) == 0) {
                level.m_7106_((ParticleOptions)ModParticles.AMETHYST_SPARKLE.get(), (double)pos.m_123341_() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.25), (double)pos.m_123342_() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.75), (double)pos.m_123343_() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.25), 0.0, 0.0, 0.0);
            }
        });
        ModBlockTickers.register((BlockState state) -> state.m_204336_(BlockTags.f_13041_) || ModConfigs.BLOCKS.vegetationFirefliesSpawnType == ModBlockConfigs.VegetationFirefliesSpawnType.GRASS_AND_FLOWERS && (state.m_60713_(Blocks.f_50034_) || state.m_60713_(Blocks.f_50359_)), () -> (Integer)ModConfigs.BLOCKS.vegetationFirefliesDensity.get() > 0, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            if (BiomeParticleManager.FIREFLY_CONDITIONS.test(level, pos) && random.m_188503_(((Integer)ModConfigs.BLOCKS.vegetationFirefliesDensity.get()).intValue()) == 0) {
                level.m_7106_((ParticleOptions)ModParticles.FIREFLY.get(), (double)pos.m_123341_() + MathUtil.nextNonAbsDouble(random), (double)pos.m_123342_() + random.m_188500_(), (double)pos.m_123343_() + MathUtil.nextNonAbsDouble(random), 0.0, 0.0, 0.0);
            }
        });
        ModBlockTickers.register((BlockState state) -> FlameGeyserTicker.VALID_BLOCKS.contains(state.m_60734_()), () -> (Integer)ModConfigs.ENVIRONMENT.flameGeyserSpawnChance.get() > 0, (BlockState state, Level level, BlockPos pos, RandomSource random) -> {
            RandomSource blockRandom;
            if (level.m_46472_().equals((Object)Level.f_46429_) && (blockRandom = RandomSource.m_216335_((long)state.m_60726_(pos))).m_188500_() < 1.0E-4 * (double)((Integer)ModConfigs.ENVIRONMENT.flameGeyserSpawnChance.get()).intValue() && !FlameGeyserTicker.ACTIVE_GEYSERS.contains(pos) && !FlameGeyserTicker.INACTIVE_GEYSERS.contains(pos) && FlameGeyserTicker.checkLocation(level, pos, true)) {
                TickerManager.add(new FlameGeyserTicker(level, pos, blockRandom));
            }
        });
    }

    private static void register(Block block, Supplier<Boolean> isEnabled, BlockTickerProvider provider) {
        if (isEnabled.get().booleanValue() && REGISTERED.put(block, provider) != null) {
            SubtleEffects.LOGGER.error("Found duplicate block tickers using {}", (Object)BuiltInRegistries.f_256975_.m_7981_((Object)block));
        }
    }

    private static void register(Predicate<BlockState> predicate, Supplier<Boolean> isEnabled, BlockTickerProvider provider) {
        if (isEnabled.get().booleanValue()) {
            REGISTERED_SPECIAL.put(predicate, provider);
        }
    }
}

