/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects;

import einstein.subtle_effects.SubtleEffectsClient;
import einstein.subtle_effects.client.model.entity.EinsteinSolarSystemModel;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemLayer;
import einstein.subtle_effects.data.BCWPPackManager;
import einstein.subtle_effects.data.MobSkullShaderReloadListener;
import einstein.subtle_effects.data.SparkProviderReloadListener;
import einstein.subtle_effects.platform.ForgeRegistryHelper;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class SubtleEffectsForgeClient {
    public SubtleEffectsForgeClient(IEventBus modEventBus) {
        SubtleEffectsClient.clientSetup();
        modEventBus.addListener(event -> ForgeRegistryHelper.PARTICLE_PROVIDERS.forEach((particle, provider) -> SubtleEffectsForgeClient.registerParticle(event, particle, provider)));
        modEventBus.addListener(event -> {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                event.addRepositorySource((RepositorySource)new BCWPSource());
            }
        });
        modEventBus.addListener(event -> {
            event.registerReloadListener((PreparableReloadListener)new SparkProviderReloadListener());
            event.registerReloadListener((PreparableReloadListener)new MobSkullShaderReloadListener());
            event.registerReloadListener((PreparableReloadListener)new BCWPPackManager());
        });
        modEventBus.addListener(event -> event.registerLayerDefinition(EinsteinSolarSystemModel.MODEL_LAYER, EinsteinSolarSystemModel::createLayer));
        modEventBus.addListener(event -> {
            for (String skinName : event.getSkins()) {
                LivingEntityRenderer renderer = event.getSkin(skinName);
                if (!(renderer instanceof PlayerRenderer)) continue;
                PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
                playerRenderer.m_115326_((RenderLayer)new EinsteinSolarSystemLayer((RenderLayerParent<?, ?>)playerRenderer, event.getContext()));
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Minecraft minecraft = Minecraft.m_91087_();
            SubtleEffectsClient.clientTick(minecraft, (Level)minecraft.f_91073_);
        });
        MinecraftForge.EVENT_BUS.addListener(event -> SubtleEffectsClient.registerClientCommands(event.getDispatcher(), event.getBuildContext()));
    }

    private static <T extends ParticleType<V>, V extends ParticleOptions> void registerParticle(RegisterParticleProvidersEvent event, Supplier<? extends ParticleType<?>> particle, Function<SpriteSet, ? extends ParticleProvider<?>> provider) {
        Supplier<ParticleType<?>> t = particle;
        Function<SpriteSet, ? extends ParticleProvider<?>> v = provider;
        event.registerSpriteSet(t.get(), sprites -> (ParticleProvider)v.apply(sprites));
    }

    public static class BCWPSource
    implements RepositorySource {
        public void m_7686_(Consumer<Pack> consumer) {
            IModInfo info = ((ModContainer)ModList.get().getModContainerById("subtle_effects").orElseThrow()).getModInfo();
            consumer.accept(Pack.m_245429_((String)("mod/" + BCWPPackManager.PACK_LOCATION.get().toString()), (Component)BCWPPackManager.PACK_NAME, (boolean)false, path -> new PathPackResources(path, info.getOwningFile().getFile().findResource(new String[]{BCWPPackManager.PACK_LOCATION.get().m_135815_()}), true), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_));
        }
    }
}

