/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.common.block;

import com.alekiponi.alekiships.common.block.AngledBoatFrameBlock;
import com.alekiponi.alekiships.common.block.BoatFrame;
import com.alekiponi.alekiships.common.block.FlatBoatFrameBlock;
import com.alekiponi.alekiships.common.block.ProcessedBoatFrame;
import com.alekiponi.alekiships.util.BoatMaterial;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ShipbuildingBlockValidator {
    private AngledBoatFrameBlock.ConstantDirection constantDirection = null;
    private AngledBoatFrameBlock.ConstantShape constantShape = null;
    private boolean flat = false;
    private boolean validatingThisBlock = false;
    private boolean shouldDestroyAbove = false;
    @Nullable
    private Direction direction = null;

    ShipbuildingBlockValidator(AngledBoatFrameBlock.ConstantShape constantShape, AngledBoatFrameBlock.ConstantDirection constantDirection) {
        this.constantShape = constantShape;
        this.constantDirection = constantDirection;
        this.validatingThisBlock = true;
    }

    ShipbuildingBlockValidator(AngledBoatFrameBlock.ConstantShape constantShape, AngledBoatFrameBlock.ConstantDirection constantDirection, boolean shouldDestroyAbove) {
        this.constantShape = constantShape;
        this.constantDirection = constantDirection;
        this.validatingThisBlock = true;
        this.shouldDestroyAbove = shouldDestroyAbove;
    }

    ShipbuildingBlockValidator(boolean flat) {
        this.flat = flat;
        this.validatingThisBlock = flat;
    }

    ShipbuildingBlockValidator(Direction direction) {
        this.constantShape = AngledBoatFrameBlock.ConstantShape.STRAIGHT;
        this.direction = direction;
        this.validatingThisBlock = true;
    }

    ShipbuildingBlockValidator(Direction direction, boolean shouldDestroyAbove) {
        this.constantShape = AngledBoatFrameBlock.ConstantShape.STRAIGHT;
        this.direction = direction;
        this.validatingThisBlock = true;
        this.shouldDestroyAbove = shouldDestroyAbove;
    }

    public boolean shouldDestroy() {
        return this.validatingThisBlock;
    }

    public boolean shouldDestroyAbove() {
        return this.shouldDestroyAbove;
    }

    public boolean validate(BlockState blockState, Direction structureDirection, BoatMaterial boatMaterial) {
        if (!this.validatingThisBlock) {
            return true;
        }
        Block block = blockState.m_60734_();
        if (!(block instanceof BoatFrame)) {
            return false;
        }
        BoatFrame boatFrame = (BoatFrame)block;
        if (boatFrame.getBoatMaterial() != boatMaterial) {
            return false;
        }
        if (boatMaterial.withstandsLava()) {
            return false;
        }
        if (boatFrame instanceof FlatBoatFrameBlock) {
            return ProcessedBoatFrame.isFullyProcessed(blockState);
        }
        if (!(blockState.m_60734_() instanceof AngledBoatFrameBlock)) {
            return false;
        }
        AngledBoatFrameBlock.ConstantDirection localConstantDirection = AngledBoatFrameBlock.ConstantDirection.getConstantDirection(blockState);
        if (localConstantDirection == null) {
            return false;
        }
        if (this.constantShape == AngledBoatFrameBlock.ConstantShape.STRAIGHT) {
            if (this.direction == null) {
                return false;
            }
            if (AngledBoatFrameBlock.ConstantShape.getConstantShape(blockState) != AngledBoatFrameBlock.ConstantShape.STRAIGHT) {
                return false;
            }
            Direction rotatedDirection = switch (structureDirection) {
                case Direction.SOUTH -> this.direction.m_122424_();
                case Direction.EAST -> this.direction.m_122427_();
                case Direction.WEST -> this.direction.m_122428_();
                default -> this.direction;
            };
            return blockState.m_61143_((Property)AngledBoatFrameBlock.FACING) == rotatedDirection && ProcessedBoatFrame.isFullyProcessed(blockState);
        }
        if (!ProcessedBoatFrame.isFullyProcessed(blockState)) {
            return false;
        }
        AngledBoatFrameBlock.ConstantDirection rotatedValidatorDirection = AngledBoatFrameBlock.ConstantDirection.rotateConstantDirection(this.constantDirection, structureDirection);
        if (localConstantDirection != rotatedValidatorDirection) {
            return false;
        }
        return this.constantShape == AngledBoatFrameBlock.ConstantShape.getConstantShape(blockState);
    }
}

