/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.client.resources;

import com.alekiponi.alekiships.client.render.texture.PaintedTexture;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PaintedTextureGenerator
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter TEXTURE_ID_CONVERTER = new FileToIdConverter("textures", ".png");
    private static final boolean EXTRA_DYE = DyeColor.values().length > 16;
    private final ResourceLocation baseTexture;
    private final ResourceLocation paintDirectory;

    public PaintedTextureGenerator(ResourceLocation baseTexture, ResourceLocation paintDirectory) {
        this.baseTexture = baseTexture;
        this.paintDirectory = paintDirectory;
    }

    public void m_6213_(ResourceManager resourceManager) {
        ResourceLocation baseTexturePath = TEXTURE_ID_CONVERTER.m_245698_(this.baseTexture);
        ResourceLocation basePath = this.baseTexture.m_246208_("textures/");
        if (EXTRA_DYE) {
            LOGGER.warn("A mod added extra dyes. Don't be surprised if some textures don't work!");
        }
        for (DyeColor dyeColor : DyeColor.values()) {
            ResourceLocation paintTexturePath = TEXTURE_ID_CONVERTER.m_245698_(this.paintDirectory.m_266382_("/" + dyeColor.m_7912_()));
            ResourceLocation outPath = basePath.m_266382_("/" + dyeColor.m_7912_());
            if (resourceManager.m_213713_(outPath).isPresent()) {
                LOGGER.debug("Skipping {} as it's already present in the resource pack", (Object)outPath);
                continue;
            }
            Minecraft.m_91087_().f_90987_.m_118495_(outPath, (AbstractTexture)new PaintedTexture(baseTexturePath, paintTexturePath));
        }
        Minecraft.m_91087_().f_90987_.m_118495_(basePath, (AbstractTexture)new SimpleTexture(baseTexturePath));
    }
}

