/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.client.render.texture;

import com.alekiponi.alekiships.client.render.util.TextureHelpers;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class PaintedTexture
extends AbstractTexture {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation baseTexturePath;
    private final ResourceLocation paintTexturePath;

    public PaintedTexture(ResourceLocation baseTexturePath, ResourceLocation paintTexturePath) {
        this.baseTexturePath = baseTexturePath;
        this.paintTexturePath = paintTexturePath;
    }

    private static NativeImage buildCombinedTexture(FrameSize resultSize, NativeImage foreground, NativeImage background) {
        NativeImage resultImage = new NativeImage(foreground.m_85102_(), foreground.m_84982_(), foreground.m_85084_(), false);
        TextureHelpers.collectFrames(foreground, resultSize).forEach(frame -> {
            int x = frame.x();
            int y = frame.y();
            background.m_260930_(resultImage, 0, 0, x, y, resultSize.f_244129_(), resultSize.f_244503_(), false, false);
            TextureHelpers.copyRect(foreground, resultImage, x, y, x, y, resultSize.f_244129_(), resultSize.f_244503_());
        });
        background.close();
        foreground.close();
        return resultImage;
    }

    private static NativeImage paintTexture(Resource baseResource, Resource paintResource) throws IOException {
        NativeImage paintTexture;
        NativeImage baseTexture;
        try (InputStream inputstream = baseResource.m_215507_();){
            baseTexture = NativeImage.m_85058_((InputStream)inputstream);
        }
        try (InputStream inputStream = paintResource.m_215507_();){
            paintTexture = NativeImage.m_85058_((InputStream)inputStream);
        }
        int paintWidth = paintTexture.m_84982_();
        int paintHeight = paintTexture.m_85084_();
        int baseWidth = baseTexture.m_84982_();
        int baseHeight = baseTexture.m_85084_();
        if (!TextureHelpers.checkAspectRatio(paintWidth, paintHeight, baseWidth, baseHeight)) {
            throw new IllegalArgumentException(String.format("Aspect ratios don't match. %sx%s and %sx%s", paintWidth, paintHeight, baseWidth, baseHeight));
        }
        FrameSize resultSize = new FrameSize(Math.max(paintWidth, baseWidth), Math.max(paintHeight, baseHeight));
        int woodScale = baseWidth > paintWidth ? baseWidth / paintWidth : 1;
        int paintScale = paintWidth > baseWidth ? paintWidth / baseWidth : 1;
        return PaintedTexture.buildCombinedTexture(resultSize, TextureHelpers.scaleImage(paintTexture, woodScale), TextureHelpers.scaleImage(baseTexture, paintScale));
    }

    public void m_6704_(ResourceManager resourceManager) throws IOException {
        NativeImage paintedImage;
        Optional baseResource = resourceManager.m_213713_(this.baseTexturePath);
        if (baseResource.isEmpty()) {
            throw new IOException(String.format("Missing base texture: %s", this.baseTexturePath));
        }
        Optional paintResource = resourceManager.m_213713_(this.paintTexturePath);
        if (paintResource.isEmpty()) {
            throw new IOException(String.format("Missing paint texture: %s", this.paintTexturePath));
        }
        try {
            paintedImage = PaintedTexture.paintTexture((Resource)baseResource.get(), (Resource)paintResource.get());
        }
        catch (IllegalArgumentException e) {
            throw new IOException(String.format("Ensure %s and %s have the same resolution", this.baseTexturePath, this.paintTexturePath), e);
        }
        LOGGER.debug("Generated overlay for Base: {}, Paint: {}", (Object)this.baseTexturePath, (Object)this.paintTexturePath);
        TextureUtil.prepareImage((int)this.m_117963_(), (int)0, (int)paintedImage.m_84982_(), (int)paintedImage.m_85084_());
        paintedImage.m_85040_(0, 0, 0, true);
    }
}

