/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.alekiships.client.render.entity.vehicle;

import com.alekiponi.alekiships.client.model.entity.RowboatEntityModel;
import com.alekiponi.alekiships.common.entity.vehicle.RowboatEntity;
import com.alekiponi.alekiships.util.CommonHelper;
import com.alekiponi.alekiships.util.VanillaWood;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.EnumMap;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RowboatRenderer
extends EntityRenderer<RowboatEntity> {
    public static final ResourceLocation DAMAGE_OVERLAY = new ResourceLocation("alekiships", "textures/entity/watercraft/rowboat/damage_overlay.png");
    protected final RowboatEntityModel rowboatModel = new RowboatEntityModel();
    protected final ResourceLocation rowboatTexture;
    protected final EnumMap<DyeColor, ResourceLocation> paintTextures;

    public RowboatRenderer(EntityRendererProvider.Context context, VanillaWood vanillaWood) {
        this(context, new ResourceLocation("alekiships", "textures/entity/watercraft/rowboat/" + vanillaWood.m_7912_()), CommonHelper.mapOfKeys(DyeColor.class, dyeColor -> new ResourceLocation("alekiships", "textures/entity/watercraft/rowboat/" + vanillaWood.m_7912_() + "/" + dyeColor.m_7912_())));
    }

    public RowboatRenderer(EntityRendererProvider.Context context, ResourceLocation rowboatTexture, EnumMap<DyeColor, ResourceLocation> paintTextures) {
        super(context);
        this.f_114477_ = 1.0f;
        this.rowboatTexture = rowboatTexture;
        this.paintTextures = paintTextures;
    }

    public void render(RowboatEntity rowboatEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (LightTexture.m_109883_((int)packedLight) < rowboatEntity.getCompartmentBlockLight()) {
            packedLight = LightTexture.m_109885_((int)rowboatEntity.getCompartmentBlockLight(), (int)this.m_114508_(rowboatEntity, rowboatEntity.m_20183_()));
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.4375, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        poseStack.m_252880_(0.0f, 1.0625f, 0.0f);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
        if (rowboatEntity.getDamage() > rowboatEntity.getDamageThreshold()) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(rowboatEntity.m_19879_() % 30)));
        }
        this.rowboatModel.setupAnim(rowboatEntity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer baseVertexConsumer = bufferSource.m_6299_(this.rowboatModel.m_103119_(this.getTextureLocation(rowboatEntity)));
        if (rowboatEntity.f_19797_ < 1) {
            poseStack.m_85849_();
            super.m_7392_((Entity)rowboatEntity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
            return;
        }
        this.rowboatModel.m_7695_(poseStack, baseVertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        switch (rowboatEntity.getOars()) {
            case ZERO: {
                break;
            }
            case ONE: {
                this.rowboatModel.getOarStarboard().m_104301_(poseStack, baseVertexConsumer, packedLight, OverlayTexture.f_118083_);
                break;
            }
            case TWO: {
                this.rowboatModel.getOarStarboard().m_104301_(poseStack, baseVertexConsumer, packedLight, OverlayTexture.f_118083_);
                this.rowboatModel.getOarPort().m_104301_(poseStack, baseVertexConsumer, packedLight, OverlayTexture.f_118083_);
            }
        }
        if (!rowboatEntity.m_5842_() && (double)rowboatEntity.getDamage() < (double)rowboatEntity.getDamageThreshold() * 0.9) {
            VertexConsumer waterMaskVertexConsumer = bufferSource.m_6299_(RenderType.m_110478_());
            this.rowboatModel.getWaterocclusion().m_104301_(poseStack, waterMaskVertexConsumer, packedLight, OverlayTexture.f_118083_);
        }
        if (0.0f < rowboatEntity.getDamage()) {
            VertexConsumer damageVertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)DAMAGE_OVERLAY));
            float alpha = Mth.m_14036_((float)(rowboatEntity.getDamage() / rowboatEntity.getDamageThreshold() * 0.75f), (float)0.0f, (float)0.5f);
            this.rowboatModel.m_7695_(poseStack, damageVertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)rowboatEntity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(RowboatEntity rowboatEntity) {
        return rowboatEntity.getPaintColor().map(this.paintTextures::get).orElse(this.rowboatTexture);
    }
}

