/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.ElevatedSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedSlopeSlabCornerSkipPredicate;

@CullTest(value={BlockType.FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER})
public final class FlatElevatedInnerSlopeSlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (blockType) {
                case BlockType.FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER -> FlatElevatedInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedInnerSlopeSlabCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> FlatElevatedInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> FlatElevatedInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedSlopeSlab(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> FlatElevatedInnerSlopeSlabCornerSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W -> FlatElevatedInnerSlopeSlabCornerSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedInnerSlopeSlabCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return FlatElevatedInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatElevatedInnerSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return FlatElevatedInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatElevatedSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return FlatElevatedInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(ElevatedSlopeSlabSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatElevatedInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(ExtendedCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatElevatedInnerSlopeSlabCornerSkipPredicate.getTriDir(dir, top, side).isEqualTo(ExtendedInnerCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    public static HalfTriangleDir getTriDir(Direction dir, boolean top, Direction side) {
        if (side == dir.m_122424_() || side == dir.m_122427_()) {
            Direction longEdge = top ? Direction.UP : Direction.DOWN;
            Direction shortEdge = side == dir.m_122424_() ? dir.m_122428_() : dir;
            return HalfTriangleDir.fromDirections(longEdge, shortEdge, false);
        }
        return HalfTriangleDir.NULL;
    }
}

