/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.stairs.vertical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slope.HalfSlopeShapes;

public final class VerticalSlopedStairsShapes
implements SplitShapeGenerator {
    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return VerticalSlopedStairsShapes.generateShapes(states, HalfSlopeShapes.SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return VerticalSlopedStairsShapes.generateShapes(states, HalfSlopeShapes.OCCLUSION_SHAPES);
    }

    private static ShapeProvider generateShapes(ImmutableList<BlockState> states, ShapeCache<HalfSlopeShapes.ShapeKey> shapeCache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape panelShape = CommonShapes.PANEL.get(Direction.NORTH);
        VoxelShape shapeUp = ShapeUtils.orUnoptimized(panelShape, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.EAST, shapeCache.get(new HalfSlopeShapes.ShapeKey(false, true))));
        VoxelShape shapeDown = ShapeUtils.orUnoptimized(panelShape, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeCache.get(new HalfSlopeShapes.ShapeKey(true, false))));
        VoxelShape shapeRight = ShapeUtils.orUnoptimized(panelShape, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, shapeCache.get(new HalfSlopeShapes.ShapeKey(false, false))));
        VoxelShape shapeLeft = ShapeUtils.orUnoptimized(panelShape, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.EAST, shapeCache.get(new HalfSlopeShapes.ShapeKey(true, true))));
        VoxelShape[] shapes = new VoxelShape[16];
        ShapeUtils.makeHorizontalRotations(shapeUp, Direction.NORTH, shapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeDown, Direction.NORTH, shapes, HorizontalRotation.DOWN.ordinal() << 2);
        ShapeUtils.makeHorizontalRotations(shapeRight, Direction.NORTH, shapes, HorizontalRotation.RIGHT.ordinal() << 2);
        ShapeUtils.makeHorizontalRotations(shapeLeft, Direction.NORTH, shapes, HorizontalRotation.LEFT.ordinal() << 2);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            int idx = dir.m_122416_() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

