/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.block.slopepanel.SlopePanelShape;
import xfacthd.framedblocks.common.block.slopeslab.SlopeSlabShape;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopepanel.SlopePanelShapes;
import xfacthd.framedblocks.common.data.shapes.slopepanelcorner.ExtendedCornerSlopePanelWallShapes;
import xfacthd.framedblocks.common.data.shapes.slopeslab.SlopeSlabShapes;

public final class CornerSlopePanelWallShapes {
    public static final ShapeCache<HorizontalRotation> SHAPES_LARGE = CornerSlopePanelWallShapes.makeCache(ExtendedCornerSlopePanelWallShapes.SHAPES, BooleanOp.f_82687_);
    public static final ShapeCache<HorizontalRotation> OCCLUSION_SHAPES_LARGE = CornerSlopePanelWallShapes.makeCache(ExtendedCornerSlopePanelWallShapes.OCCLUSION_SHAPES, BooleanOp.f_82687_);
    public static final ShapeCache<HorizontalRotation> SHAPES_SMALL_INNER = CornerSlopePanelWallShapes.makeCache(ExtendedCornerSlopePanelWallShapes.INNER_SHAPES, BooleanOp.f_82689_);
    public static final ShapeCache<HorizontalRotation> OCCLUSION_SHAPES_SMALL_INNER = CornerSlopePanelWallShapes.makeCache(ExtendedCornerSlopePanelWallShapes.INNER_OCCLUSION_SHAPES, BooleanOp.f_82689_);

    private static ShapeCache<HorizontalRotation> makeCache(ShapeCache<HorizontalRotation> cache, BooleanOp joinOp) {
        return ShapeCache.createEnum(HorizontalRotation.class, map -> {
            for (HorizontalRotation rot : HorizontalRotation.values()) {
                map.put(rot, Shapes.m_83148_((VoxelShape)cache.get(rot), (VoxelShape)rot.getCornerShape(), (BooleanOp)joinOp));
            }
        });
    }

    public static final class LargeInner
    implements SplitShapeGenerator {
        @Override
        public ShapeProvider generate(ImmutableList<BlockState> states) {
            return LargeInner.generate(states, SlopeSlabShapes.SHAPES, SlopePanelShapes.SHAPES);
        }

        @Override
        public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
            return LargeInner.generate(states, SlopeSlabShapes.OCCLUSION_SHAPES, SlopePanelShapes.OCCLUSION_SHAPES);
        }

        private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<SlopeSlabShape> slabCache, ShapeCache<SlopePanelShape> panelCache) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            VoxelShape shapeOneUpLeft = ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.EAST, panelCache.get(SlopePanelShape.RIGHT_BACK));
            VoxelShape shapeOneDownRight = ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelCache.get(SlopePanelShape.LEFT_BACK));
            VoxelShape[] shapes = new VoxelShape[16];
            for (HorizontalRotation rot : HorizontalRotation.values()) {
                VoxelShape shapeOne = switch (rot) {
                    default -> throw new IncompatibleClassChangeError();
                    case HorizontalRotation.UP, HorizontalRotation.LEFT -> shapeOneUpLeft;
                    case HorizontalRotation.DOWN, HorizontalRotation.RIGHT -> shapeOneDownRight;
                };
                VoxelShape shapeTwo = switch (rot) {
                    default -> throw new IncompatibleClassChangeError();
                    case HorizontalRotation.UP, HorizontalRotation.RIGHT -> slabCache.get(SlopeSlabShape.BOTTOM_BOTTOM_HALF);
                    case HorizontalRotation.LEFT, HorizontalRotation.DOWN -> slabCache.get(SlopeSlabShape.TOP_TOP_HALF);
                };
                VoxelShape preShape = ShapeUtils.orUnoptimized(shapeOne, shapeTwo);
                ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
            }
            for (BlockState state : states) {
                HorizontalRotation rot;
                Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
                int idx = dir.m_122416_() | rot.ordinal() << 2;
                builder.put((Object)state, (Object)shapes[idx]);
            }
            return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
        }
    }

    public static final class SmallInner
    implements SplitShapeGenerator {
        @Override
        public ShapeProvider generate(ImmutableList<BlockState> states) {
            return SmallInner.generate(states, SHAPES_SMALL_INNER);
        }

        @Override
        public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
            return SmallInner.generate(states, OCCLUSION_SHAPES_SMALL_INNER);
        }

        private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<HorizontalRotation> cache) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            VoxelShape[] shapes = new VoxelShape[16];
            for (HorizontalRotation rot : HorizontalRotation.values()) {
                VoxelShape preShape = cache.get(rot);
                ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
            }
            for (BlockState state : states) {
                HorizontalRotation rot;
                Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
                int idx = dir.m_122416_() | rot.ordinal() << 2;
                builder.put((Object)state, (Object)shapes[idx]);
            }
            return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
        }
    }

    public static final class LargeOuter
    implements SplitShapeGenerator {
        @Override
        public ShapeProvider generate(ImmutableList<BlockState> states) {
            return LargeOuter.generate(states, SHAPES_LARGE);
        }

        @Override
        public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
            return LargeOuter.generate(states, OCCLUSION_SHAPES_LARGE);
        }

        private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<HorizontalRotation> cache) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            VoxelShape[] shapes = new VoxelShape[16];
            for (HorizontalRotation rot : HorizontalRotation.values()) {
                VoxelShape preShape = cache.get(rot);
                ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
            }
            for (BlockState state : states) {
                HorizontalRotation rot;
                Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
                int idx = dir.m_122416_() | rot.ordinal() << 2;
                builder.put((Object)state, (Object)shapes[idx]);
            }
            return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
        }
    }

    public static final class SmallOuter
    implements SplitShapeGenerator {
        @Override
        public ShapeProvider generate(ImmutableList<BlockState> states) {
            return SmallOuter.generate(states, SlopeSlabShapes.SHAPES, SlopePanelShapes.SHAPES);
        }

        @Override
        public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
            return SmallOuter.generate(states, SlopeSlabShapes.OCCLUSION_SHAPES, SlopePanelShapes.OCCLUSION_SHAPES);
        }

        private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<SlopeSlabShape> slabCache, ShapeCache<SlopePanelShape> panelCache) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            VoxelShape shapeOneUpLeft = ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelCache.get(SlopePanelShape.LEFT_BACK));
            VoxelShape shapeOneDownRight = ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.EAST, panelCache.get(SlopePanelShape.RIGHT_BACK));
            VoxelShape[] shapes = new VoxelShape[16];
            for (HorizontalRotation rot : HorizontalRotation.values()) {
                VoxelShape shapeOne = switch (rot) {
                    default -> throw new IncompatibleClassChangeError();
                    case HorizontalRotation.UP, HorizontalRotation.LEFT -> shapeOneUpLeft;
                    case HorizontalRotation.DOWN, HorizontalRotation.RIGHT -> shapeOneDownRight;
                };
                VoxelShape shapeTwo = switch (rot) {
                    default -> throw new IncompatibleClassChangeError();
                    case HorizontalRotation.UP, HorizontalRotation.RIGHT -> slabCache.get(SlopeSlabShape.TOP_TOP_HALF);
                    case HorizontalRotation.LEFT, HorizontalRotation.DOWN -> slabCache.get(SlopeSlabShape.BOTTOM_BOTTOM_HALF);
                };
                VoxelShape preShape = ShapeUtils.andUnoptimized(shapeOne, shapeTwo);
                ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
            }
            for (BlockState state : states) {
                HorizontalRotation rot;
                Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
                int idx = dir.m_122416_() | rot.ordinal() << 2;
                builder.put((Object)state, (Object)shapes[idx]);
            }
            return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
        }
    }
}

