/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.block.slopepanel.SlopePanelShape;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopepanel.SlopePanelShapes;

public final class InverseDoubleSlopePanelShapes
implements SplitShapeGenerator {
    public static final InverseDoubleSlopePanelShapes INSTANCE = new InverseDoubleSlopePanelShapes();
    private static final ShapeCache<ShapeKey> SHAPES = InverseDoubleSlopePanelShapes.makeCache(SlopePanelShapes.SHAPES);
    private static final ShapeCache<ShapeKey> OCCLUSION_SHAPES = InverseDoubleSlopePanelShapes.makeCache(SlopePanelShapes.OCCLUSION_SHAPES);

    private InverseDoubleSlopePanelShapes() {
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return InverseDoubleSlopePanelShapes.generate(states, SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return InverseDoubleSlopePanelShapes.generate(states, OCCLUSION_SHAPES);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<ShapeKey> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            builder.put((Object)state, (Object)cache.get(new ShapeKey(dir, rot)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static ShapeCache<ShapeKey> makeCache(ShapeCache<SlopePanelShape> cache) {
        return ShapeCache.create(map -> {
            for (HorizontalRotation rot : HorizontalRotation.values()) {
                HorizontalRotation rotOne = rot.isVertical() ? rot.getOpposite() : rot;
                VoxelShape shapeOne = cache.get(SlopePanelShape.get(rotOne, true));
                VoxelShape preShape = ShapeUtils.orUnoptimized(ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.SOUTH, shapeOne), cache.get(SlopePanelShape.get(rot, true)));
                ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, map, rot, ShapeKey::new);
            }
        });
    }

    private record ShapeKey(Direction dir, HorizontalRotation rot) {
    }
}

