/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block.render;

import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.render.ParticleHelper;

public class FramedBlockRenderProperties
implements IClientBlockExtensions {
    public static final FramedBlockRenderProperties INSTANCE = new FramedBlockRenderProperties();

    protected FramedBlockRenderProperties() {
    }

    public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine engine) {
        BlockEntity blockEntity;
        BlockHitResult hit = (BlockHitResult)target;
        boolean suppressed = FramedBlockRenderProperties.suppressParticles(state, level, hit.m_82425_());
        if (!suppressed && (blockEntity = level.m_7702_(hit.m_82425_())) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return this.addHitEffectsUnsuppressed(state, level, hit, be, engine);
        }
        return suppressed;
    }

    protected boolean addHitEffectsUnsuppressed(BlockState state, Level level, BlockHitResult hit, FramedBlockEntity be, ParticleEngine engine) {
        ParticleHelper.Client.addHitEffects(state, level, hit, be.getCamo().getState(), engine);
        return true;
    }

    public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine engine) {
        BlockEntity blockEntity;
        boolean suppressed = FramedBlockRenderProperties.suppressParticles(state, level, pos);
        if (!suppressed && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return this.addDestroyEffectsUnsuppressed(state, level, pos, be, engine);
        }
        return suppressed;
    }

    protected boolean addDestroyEffectsUnsuppressed(BlockState state, Level level, BlockPos pos, FramedBlockEntity be, ParticleEngine engine) {
        ParticleHelper.Client.addDestroyEffects(state, level, pos, be.getCamo().getState(), engine);
        return true;
    }

    protected static boolean suppressParticles(BlockState state, Level level, BlockPos pos) {
        IFramedBlock block;
        Block block2 = state.m_60734_();
        if (block2 instanceof IFramedBlock && (block = (IFramedBlock)block2).getBlockType().allowMakingIntangible()) {
            return block.isIntangible(state, (BlockGetter)level, pos, null);
        }
        return false;
    }
}

