/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.goals;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import tallestegg.guardvillagers.GuardEntityType;

public class HealGuardAndPlayerGoal
extends Goal {
    private final Mob healer;
    private LivingEntity mob;
    private int rangedAttackTime = -1;
    private final double entityMoveSpeed;
    private int seeTime;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistance;
    protected final TargetingConditions predicate = TargetingConditions.m_148353_().m_26883_(64.0);

    public HealGuardAndPlayerGoal(Mob healer, double movespeed, int attackIntervalMin, int maxAttackTime, float maxAttackDistanceIn) {
        this.healer = healer;
        this.entityMoveSpeed = movespeed;
        this.attackIntervalMin = attackIntervalMin;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistanceIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (((Villager)this.healer).m_7141_().m_35571_() != VillagerProfession.f_35589_ || this.healer.m_5803_()) {
            return false;
        }
        List list = this.healer.m_9236_().m_45976_(LivingEntity.class, this.healer.m_20191_().m_82377_(10.0, 3.0, 10.0));
        if (!list.isEmpty()) {
            for (LivingEntity mob : list) {
                if (mob == null || !(mob instanceof Villager && mob.m_6084_() && mob.m_21223_() < mob.m_21233_() && mob != this.healer || mob.m_6095_() == GuardEntityType.GUARD.get() && mob != null && mob.m_6084_() && mob.m_21223_() < mob.m_21233_()) && (!(mob instanceof Player) || !mob.m_21023_(MobEffects.f_19595_) || ((Player)mob).m_150110_().f_35937_ || !(mob.m_21223_() < mob.m_21233_()))) continue;
                this.mob = mob;
                return true;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        return this.m_8036_() && this.mob != null && this.mob.m_21223_() < this.mob.m_21233_();
    }

    public void m_8041_() {
        this.mob = null;
        this.seeTime = 0;
        this.healer.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        this.rangedAttackTime = 0;
    }

    public void m_8037_() {
        if (this.mob == null) {
            return;
        }
        double d0 = this.healer.m_20275_(this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
        boolean flag = this.healer.m_21574_().m_148306_((Entity)this.mob);
        this.seeTime = flag ? ++this.seeTime : 0;
        BehaviorUtils.m_22595_((LivingEntity)this.healer, (LivingEntity)this.mob);
        if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 5) {
            this.healer.m_21573_().m_26573_();
        } else {
            this.healer.m_21573_().m_5624_((Entity)this.healer, this.entityMoveSpeed);
        }
        if ((double)this.mob.m_20270_((Entity)this.healer) <= 3.0) {
            this.healer.m_21566_().m_24988_(-0.5f, 0.0f);
        }
        if (--this.rangedAttackTime == 0) {
            if (!flag) {
                return;
            }
            float f = this.attackRadius;
            float distanceFactor = Mth.m_14036_((float)f, (float)0.1f, (float)0.1f);
            this.throwPotion(this.mob, distanceFactor);
            this.rangedAttackTime = Mth.m_14143_((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.rangedAttackTime < 0) {
            this.rangedAttackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.maxAttackDistance));
        }
    }

    public void throwPotion(LivingEntity target, float distanceFactor) {
        Vec3 vec3d = target.m_20184_();
        double d0 = target.m_20185_() + vec3d.f_82479_ - this.healer.m_20185_();
        double d1 = target.m_20188_() - (double)1.1f - this.healer.m_20186_();
        double d2 = target.m_20189_() + vec3d.f_82481_ - this.healer.m_20189_();
        float f = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        Potion potion = Potions.f_43587_;
        potion = target.m_21223_() <= 4.0f ? Potions.f_43623_ : Potions.f_43587_;
        ThrownPotion potionentity = new ThrownPotion(this.healer.m_9236_(), (LivingEntity)this.healer);
        potionentity.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potion));
        potionentity.m_146926_(-20.0f);
        potionentity.m_6686_(d0, d1 + (double)(f * 0.2f), d2, 0.75f, 8.0f);
        this.healer.m_9236_().m_6263_((Player)null, this.healer.m_20185_(), this.healer.m_20186_(), this.healer.m_20189_(), SoundEvents.f_12437_, this.healer.m_5720_(), 1.0f, 0.8f + this.healer.m_217043_().m_188501_() * 0.4f);
        this.healer.m_9236_().m_7967_((Entity)potionentity);
    }
}

