/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.PacketDistributor;
import tallestegg.guardvillagers.GuardLootTables;
import tallestegg.guardvillagers.GuardPacketHandler;
import tallestegg.guardvillagers.GuardVillagers;
import tallestegg.guardvillagers.ModCompat;
import tallestegg.guardvillagers.client.GuardSounds;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.GuardContainer;
import tallestegg.guardvillagers.entities.ai.goals.ArmorerRepairGuardArmorGoal;
import tallestegg.guardvillagers.entities.ai.goals.FollowShieldGuards;
import tallestegg.guardvillagers.entities.ai.goals.GuardEatFoodGoal;
import tallestegg.guardvillagers.entities.ai.goals.GuardInteractDoorGoal;
import tallestegg.guardvillagers.entities.ai.goals.GuardLookAtAndStopMovingWhenBeingTheInteractionTarget;
import tallestegg.guardvillagers.entities.ai.goals.GuardRunToEatGoal;
import tallestegg.guardvillagers.entities.ai.goals.HeroHurtByTargetGoal;
import tallestegg.guardvillagers.entities.ai.goals.HeroHurtTargetGoal;
import tallestegg.guardvillagers.entities.ai.goals.KickGoal;
import tallestegg.guardvillagers.entities.ai.goals.RaiseShieldGoal;
import tallestegg.guardvillagers.entities.ai.goals.RangedCrossbowAttackPassiveGoal;
import tallestegg.guardvillagers.entities.ai.goals.RunToClericGoal;
import tallestegg.guardvillagers.entities.ai.goals.WalkBackToCheckPointGoal;
import tallestegg.guardvillagers.networking.GuardOpenInventoryPacket;

public class Guard
extends PathfinderMob
implements CrossbowAttackMob,
RangedAttackMob,
NeutralMob,
ContainerListener,
ReputationEventHandler {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(Guard.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier USE_ITEM_SPEED_PENALTY = new AttributeModifier(MODIFIER_UUID, "Use item speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Optional<BlockPos>> GUARD_POS = SynchedEntityData.m_135353_(Guard.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Boolean> PATROLLING = SynchedEntityData.m_135353_(Guard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> GUARD_VARIANT = SynchedEntityData.m_135353_(Guard.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> RUNNING_TO_EAT = SynchedEntityData.m_135353_(Guard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_STATE = SynchedEntityData.m_135353_(Guard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> KICKING = SynchedEntityData.m_135353_(Guard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FOLLOWING = SynchedEntityData.m_135353_(Guard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Map<Pose, EntityDimensions> SIZE_BY_POSE = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)1.95f)).put((Object)Pose.SLEEPING, (Object)f_20910_).put((Object)Pose.FALL_FLYING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.SWIMMING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.SPIN_ATTACK, (Object)EntityDimensions.m_20395_((float)0.6f, (float)0.6f)).put((Object)Pose.CROUCHING, (Object)EntityDimensions.m_20395_((float)0.6f, (float)1.75f)).put((Object)Pose.DYING, (Object)EntityDimensions.m_20398_((float)0.2f, (float)0.2f)).build();
    private static final UniformInt angerTime = TimeUtil.m_145020_((int)20, (int)39);
    private final GossipContainer gossips = new GossipContainer();
    public long lastGossipTime;
    public long lastGossipDecayTime;
    public SimpleContainer guardInventory = new SimpleContainer(6);
    public int kickTicks;
    public int shieldCoolDown;
    public int kickCoolDown;
    public boolean interacting;
    protected boolean spawnWithArmor;
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;
    private LazyOptional<?> itemHandler;

    public Guard(EntityType<? extends Guard> type, Level world) {
        super(type, world);
        this.guardInventory.m_19164_((ContainerListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.guardInventory));
        this.m_21530_();
        if (GuardConfig.GuardsOpenDoors) {
            ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        }
    }

    public static int slotToInventoryIndex(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.CHEST -> 1;
            case EquipmentSlot.FEET -> 3;
            case EquipmentSlot.LEGS -> 2;
            default -> 0;
        };
    }

    public static String getVariantFromBiome(LevelAccessor world, BlockPos pos) {
        VillagerType type = VillagerType.m_204073_((Holder)world.m_204166_(pos));
        return GuardVillagers.removeModIdFromVillagerType(type.toString());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)GuardConfig.COMMON.healthModifier.get()).doubleValue()).m_22268_(Attributes.f_22279_, ((Double)GuardConfig.COMMON.speedModifier.get()).doubleValue()).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, ((Double)GuardConfig.COMMON.followRangeModifier.get()).doubleValue());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.m_21530_();
        this.setGuardVariant(Guard.getVariantFromBiome((LevelAccessor)this.m_9236_(), this.m_20183_()));
        RandomSource randomsource = worldIn.m_213780_();
        this.m_213945_(randomsource, difficultyIn);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_7324_(Entity entityIn) {
        if (entityIn instanceof PathfinderMob) {
            boolean attackTargets;
            PathfinderMob living = (PathfinderMob)entityIn;
            boolean bl = attackTargets = living.m_5448_() instanceof Villager || living.m_5448_() instanceof IronGolem || living.m_5448_() instanceof Guard;
            if (attackTargets) {
                this.m_6710_((LivingEntity)living);
            }
        }
        super.m_7324_(entityIn);
    }

    @Nullable
    public BlockPos getPatrolPos() {
        return ((Optional)this.f_19804_.m_135370_(GUARD_POS)).orElse(null);
    }

    @Nullable
    public void setPatrolPos(BlockPos position) {
        this.f_19804_.m_135381_(GUARD_POS, Optional.ofNullable(position));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)GuardSounds.GUARD_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)GuardSounds.GUARD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)GuardSounds.GUARD_DEATH.get();
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        for (int i = 0; i < this.guardInventory.m_6643_(); ++i) {
            ItemStack itemstack = this.guardInventory.m_8020_(i);
            RandomSource randomsource = this.m_9236_().m_213780_();
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack) || !(randomsource.m_188501_() < ((Double)GuardConfig.COMMON.chanceToDropEquipment.get()).floatValue())) continue;
            this.m_19983_(itemstack);
        }
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        if (compound.m_128425_("Type", 99)) {
            int variantint = compound.m_128451_("Type");
            if (variantint == 1) {
                compound.m_128359_("Variant", "desert");
            } else if (variantint == 2) {
                compound.m_128359_("Variant", "savanna");
            } else if (variantint == 3) {
                compound.m_128359_("Variant", "swamp");
            } else if (variantint == 4) {
                compound.m_128359_("Variant", "jungle");
            } else if (variantint == 5) {
                compound.m_128359_("Variant", "taiga");
            } else if (variantint == 6) {
                compound.m_128359_("Variant", "snow");
            } else if (variantint == 0) {
                compound.m_128359_("Variant", "plains");
            }
        }
        UUID uUID = uuid = compound.m_128403_("Owner") ? compound.m_128342_("Owner") : null;
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                this.setOwnerId(null);
            }
        }
        if (compound.m_128441_("Variant")) {
            this.setGuardVariant(GuardVillagers.removeModIdFromVillagerType(compound.m_128461_("Variant")));
        }
        this.kickTicks = compound.m_128451_("KickTicks");
        this.setFollowing(compound.m_128471_("Following"));
        this.interacting = compound.m_128471_("Interacting");
        this.setPatrolling(compound.m_128471_("Patrolling"));
        this.shieldCoolDown = compound.m_128451_("KickCooldown");
        this.kickCoolDown = compound.m_128451_("ShieldCooldown");
        this.lastGossipDecayTime = compound.m_128454_("LastGossipDecay");
        this.lastGossipTime = compound.m_128454_("LastGossipTime");
        this.spawnWithArmor = compound.m_128471_("SpawnWithArmor");
        if (compound.m_128441_("PatrolPosX")) {
            int x = compound.m_128451_("PatrolPosX");
            int y = compound.m_128451_("PatrolPosY");
            int z = compound.m_128451_("PatrolPosZ");
            this.f_19804_.m_135381_(GUARD_POS, Optional.ofNullable(new BlockPos(x, y, z)));
        }
        ListTag listtag = compound.m_128437_("Gossips", 10);
        this.gossips.m_26177_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)listtag));
        ListTag listnbt = compound.m_128437_("Inventory", 9);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            int j = compoundnbt.m_128445_("Slot") & 0xFF;
            this.guardInventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
        }
        if (compound.m_128425_("ArmorItems", 9)) {
            ListTag armorItems = compound.m_128437_("ArmorItems", 10);
            for (int i = 0; i < this.f_21351_.size(); ++i) {
                int index = Guard.slotToInventoryIndex(Mob.m_147233_((ItemStack)ItemStack.m_41712_((CompoundTag)armorItems.m_128728_(i))));
                this.guardInventory.m_6836_(index, ItemStack.m_41712_((CompoundTag)armorItems.m_128728_(i)));
            }
        }
        if (compound.m_128425_("HandItems", 9)) {
            ListTag handItems = compound.m_128437_("HandItems", 10);
            for (int i = 0; i < this.f_21350_.size(); ++i) {
                int handSlot = i == 0 ? 5 : 4;
                this.guardInventory.m_6836_(handSlot, ItemStack.m_41712_((CompoundTag)handItems.m_128728_(i)));
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.m_147285_(this.m_9236_(), compound);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Variant", this.getGuardVariant());
        compound.m_128405_("KickTicks", this.kickTicks);
        compound.m_128405_("ShieldCooldown", this.shieldCoolDown);
        compound.m_128405_("KickCooldown", this.kickCoolDown);
        compound.m_128379_("Following", this.isFollowing());
        compound.m_128379_("Interacting", this.interacting);
        compound.m_128379_("Patrolling", this.isPatrolling());
        compound.m_128379_("SpawnWithArmor", this.spawnWithArmor);
        compound.m_128356_("LastGossipTime", this.lastGossipTime);
        compound.m_128356_("LastGossipDecay", this.lastGossipDecayTime);
        if (this.getOwnerId() != null) {
            compound.m_128362_("Owner", this.getOwnerId());
        }
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.guardInventory.m_6643_(); ++i) {
            ItemStack itemstack = this.guardInventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        compound.m_128365_("Inventory", (Tag)listnbt);
        if (this.getPatrolPos() != null) {
            compound.m_128405_("PatrolPosX", this.getPatrolPos().m_123341_());
            compound.m_128405_("PatrolPosY", this.getPatrolPos().m_123342_());
            compound.m_128405_("PatrolPosZ", this.getPatrolPos().m_123343_());
        }
        compound.m_128365_("Gossips", (Tag)this.gossips.m_262795_((DynamicOps)NbtOps.f_128958_));
        this.m_21678_(compound);
    }

    private void maybeDecayGossip() {
        long i = this.m_9236_().m_46467_();
        if (this.lastGossipDecayTime == 0L) {
            this.lastGossipDecayTime = i;
        } else if (i >= this.lastGossipDecayTime + 24000L) {
            this.gossips.m_26198_();
            this.lastGossipDecayTime = i;
        }
    }

    protected void m_8095_() {
        if (this.m_6117_()) {
            InteractionHand interactionhand = this.m_7655_();
            if (!this.f_20935_.equals(this.m_21120_(interactionhand))) {
                this.m_21253_();
            } else if (!this.f_20935_.m_41619_() && this.m_6117_()) {
                this.m_21137_(this.f_20935_, 16);
                ItemStack copy = this.f_20935_.m_41777_();
                ItemStack itemstack = ForgeEventFactory.onItemUseFinish((LivingEntity)this, (ItemStack)copy, (int)this.m_21212_(), (ItemStack)this.f_20935_.m_41671_(this.m_9236_(), (LivingEntity)this));
                if (itemstack != this.f_20935_) {
                    this.m_21008_(interactionhand, itemstack);
                }
                if (!this.f_20935_.m_41614_()) {
                    this.f_20935_.m_41774_(1);
                }
                this.m_5810_();
            }
        }
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        switch (pSlot) {
            case HEAD: {
                return this.guardInventory.m_8020_(0);
            }
            case CHEST: {
                return this.guardInventory.m_8020_(1);
            }
            case LEGS: {
                return this.guardInventory.m_8020_(2);
            }
            case FEET: {
                return this.guardInventory.m_8020_(3);
            }
            case OFFHAND: {
                return this.guardInventory.m_8020_(4);
            }
            case MAINHAND: {
                return this.guardInventory.m_8020_(5);
            }
        }
        return ItemStack.f_41583_;
    }

    public GossipContainer getGossips() {
        return this.gossips;
    }

    public int getPlayerReputation(Player player) {
        return this.gossips.m_26195_(player.m_20148_(), gossipType -> true);
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            boolean heroOfTheVillage = uuid != null && this.m_9236_().m_46003_(uuid) != null && this.m_9236_().m_46003_(uuid).m_21023_(MobEffects.f_19595_);
            return uuid == null || this.m_9236_().m_46003_(uuid) != null && !heroOfTheVillage && GuardConfig.followHero || !GuardConfig.followHero && this.m_9236_().m_46003_(uuid) == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean isOwner(LivingEntity entityIn) {
        return entityIn == this.getOwner();
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.isKicking()) {
            ((LivingEntity)entityIn).m_147240_(1.0, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
            this.kickTicks = 10;
            this.m_9236_().m_7605_((Entity)this, (byte)4);
            this.m_21391_(entityIn, 90.0f, 90.0f);
        }
        ItemStack hand = this.m_21205_();
        this.damageGuardItem(1, EquipmentSlot.MAINHAND, hand);
        return super.m_7327_(entityIn);
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.kickTicks = 10;
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_6107_() {
        return this.interacting || super.m_6107_();
    }

    public void m_6667_(DamageSource source) {
        if ((this.m_9236_().m_46791_() == Difficulty.NORMAL || this.m_9236_().m_46791_() == Difficulty.HARD) && source.m_7639_() instanceof Zombie && ForgeEventFactory.canLivingConvert((LivingEntity)((LivingEntity)source.m_7639_()), (EntityType)EntityType.f_20530_, timer -> {})) {
            ZombieVillager zombieguard = (ZombieVillager)this.m_21406_(EntityType.f_20530_, true);
            if (this.m_9236_().m_46791_() != Difficulty.HARD && this.f_19796_.m_188499_() || zombieguard == null) {
                return;
            }
            zombieguard.m_6518_((ServerLevelAccessor)this.m_9236_(), this.m_9236_().m_6436_(zombieguard.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true), (CompoundTag)null);
            if (!this.m_20067_()) {
                this.m_9236_().m_5898_(null, 1026, this.m_20183_(), 0);
            }
            this.m_146870_();
        }
        super.m_6667_(source);
    }

    public ItemStack m_5584_(Level world, ItemStack stack) {
        if (stack.m_41614_()) {
            this.m_5634_(stack.m_41720_().getFoodProperties(stack, (LivingEntity)this).m_38744_());
        }
        world.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
        super.m_5584_(world, stack);
        return stack;
    }

    public void m_8107_() {
        if (this.kickTicks > 0) {
            --this.kickTicks;
        }
        if (this.kickCoolDown > 0) {
            --this.kickCoolDown;
        }
        if (this.shieldCoolDown > 0) {
            --this.shieldCoolDown;
        }
        if (this.m_21223_() < this.m_21233_() && this.f_19797_ % 200 == 0) {
            this.m_5634_(GuardConfig.amountOfHealthRegenerated);
        }
        if (this.spawnWithArmor) {
            Guard.getItemsFromLootTable((LivingEntity)this);
            this.spawnWithArmor = false;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        this.m_21203_();
        super.m_8107_();
    }

    public void m_8119_() {
        this.maybeDecayGossip();
        super.m_8119_();
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return SIZE_BY_POSE.getOrDefault(poseIn, EntityDimensions.m_20395_((float)0.6f, (float)1.95f));
    }

    public float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (poseIn == Pose.CROUCHING) {
            return 1.4f;
        }
        return super.m_6431_(poseIn, sizeIn);
    }

    protected void m_6728_(LivingEntity entityIn) {
        super.m_6728_(entityIn);
        this.m_5496_(SoundEvents.f_12346_, 1.0f, 1.0f);
        if (entityIn.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, entityIn)) {
            this.disableShield(true);
        }
    }

    protected void m_7909_(float damage) {
        if (this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK) && damage >= 3.0f) {
            int i = 1 + Mth.m_14143_((float)damage);
            InteractionHand hand = this.m_7655_();
            this.damageGuardItem(i, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, this.f_20935_);
            this.f_20935_.m_41622_(i, (LivingEntity)this, entity -> entity.m_21190_(hand));
            if (this.f_20935_.m_41619_()) {
                if (hand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    public void m_6672_(InteractionHand hand) {
        super.m_6672_(hand);
        ItemStack itemstack = this.m_21120_(hand);
        if (itemstack.canPerformAction(ToolActions.SHIELD_BLOCK)) {
            AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
            modifiableattributeinstance.m_22130_(USE_ITEM_SPEED_PENALTY);
            modifiableattributeinstance.m_22118_(USE_ITEM_SPEED_PENALTY);
        }
    }

    public void m_5810_() {
        super.m_5810_();
        if (this.m_21051_(Attributes.f_22279_).m_22109_(USE_ITEM_SPEED_PENALTY)) {
            this.m_21051_(Attributes.f_22279_).m_22130_(USE_ITEM_SPEED_PENALTY);
        }
    }

    public void disableShield(boolean increase) {
        float chance = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
        if (increase) {
            chance = (float)((double)chance + 0.75);
        }
        if (this.f_19796_.m_188501_() < chance) {
            this.shieldCoolDown = 100;
            this.m_5810_();
            this.m_9236_().m_7605_((Entity)this, (byte)30);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GUARD_VARIANT, (Object)VillagerType.f_35821_.toString());
        this.f_19804_.m_135372_(DATA_CHARGING_STATE, (Object)false);
        this.f_19804_.m_135372_(KICKING, (Object)false);
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.f_19804_.m_135372_(FOLLOWING, (Object)false);
        this.f_19804_.m_135372_(GUARD_POS, Optional.empty());
        this.f_19804_.m_135372_(PATROLLING, (Object)false);
        this.f_19804_.m_135372_(RUNNING_TO_EAT, (Object)false);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHARGING_STATE);
    }

    public void m_6136_(boolean charging) {
        this.f_19804_.m_135381_(DATA_CHARGING_STATE, (Object)charging);
    }

    public boolean isKicking() {
        return (Boolean)this.f_19804_.m_135370_(KICKING);
    }

    public void setKicking(boolean kicking) {
        this.f_19804_.m_135381_(KICKING, (Object)kicking);
    }

    protected void m_213945_(RandomSource source, DifficultyInstance instance) {
        this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 100.0f;
        this.f_21347_[EquipmentSlot.OFFHAND.m_20749_()] = 100.0f;
        this.spawnWithArmor = true;
    }

    public static List<ItemStack> getItemsFromLootTable(LivingEntity entity) {
        LootTable loot = entity.m_9236_().m_7654_().m_278653_().m_278676_(new ResourceLocation("guardvillagers", "entities/guard_armor"));
        LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)entity.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)entity);
        return loot.m_287195_(lootcontext$builder.m_287235_(GuardLootTables.SLOT));
    }

    public String getGuardVariant() {
        String variant = (String)this.f_19804_.m_135370_(GUARD_VARIANT);
        return !variant.isEmpty() ? variant : "plains";
    }

    public void setGuardVariant(String typeId) {
        this.f_19804_.m_135381_(GUARD_VARIANT, (Object)typeId);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new KickGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new GuardEatFoodGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new RaiseShieldGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new GuardRunToEatGoal(this));
        this.f_21345_.m_25352_(3, new RangedCrossbowAttackPassiveGoal<Guard>(this, 1.0, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 0.5, 20, 15.0f){

            public boolean m_8036_() {
                return Guard.this.m_5448_() != null && this.isBowInMainhand() && !Guard.this.isEating() && !Guard.this.m_21254_();
            }

            protected boolean isBowInMainhand() {
                return Guard.this.m_21205_().m_41720_() instanceof BowItem;
            }

            public void m_8037_() {
                super.m_8037_();
                if (Guard.this.m_5448_() != null) {
                    Guard.this.m_21563_().m_24960_((Entity)Guard.this.m_5448_(), 30.0f, 30.0f);
                }
                if (Guard.this.isPatrolling()) {
                    Guard.this.m_21573_().m_26573_();
                    Guard.this.m_21566_().m_24988_(0.0f, 0.0f);
                }
                if (RangedCrossbowAttackPassiveGoal.friendlyInLineOfSight((Mob)Guard.this)) {
                    Guard.this.m_5810_();
                }
            }

            public boolean m_8045_() {
                return (this.m_8036_() || !Guard.this.m_21573_().m_26571_()) && this.isBowInMainhand();
            }
        });
        if (ModList.get().isLoaded("musketmod")) {
            this.f_21345_.m_25352_(3, new ModCompat.UseMusketGoal<Guard>(this, 20, 15.0f));
        }
        this.f_21345_.m_25352_(3, (Goal)new GuardMeleeGoal(this, 0.8, true));
        this.f_21345_.m_25352_(4, (Goal)new FollowHeroGoal(this, 0.8f, 10.0f, 4.0f));
        if (GuardConfig.GuardsRunFromPolarBears) {
            this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 12.0f, 1.0, 1.2));
        }
        this.f_21345_.m_25352_(4, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.5, false));
        if (GuardConfig.GuardsOpenDoors) {
            this.f_21345_.m_25352_(4, (Goal)new GuardInteractDoorGoal(this, true));
        }
        if (GuardConfig.GuardFormation) {
            this.f_21345_.m_25352_(6, (Goal)new FollowShieldGuards(this));
        }
        if (GuardConfig.ClericHealing) {
            this.f_21345_.m_25352_(6, (Goal)new RunToClericGoal(this));
        }
        if (GuardConfig.armorerRepairGuardArmor) {
            this.f_21345_.m_25352_(6, (Goal)new ArmorerRepairGuardArmorGoal(this));
        }
        this.f_21345_.m_25352_(5, (Goal)new WalkBackToCheckPointGoal(this, 0.5));
        this.f_21345_.m_25352_(5, (Goal)new GolemRandomStrollInVillageGoal((PathfinderMob)this, 0.5));
        if (((Boolean)GuardConfig.COMMON.guardPatrol.get()).booleanValue()) {
            this.f_21345_.m_25352_(5, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 0.5, false, 4, () -> false));
        }
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, AbstractVillager.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new GuardLookAtAndStopMovingWhenBeingTheInteractionTarget(this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Guard.class, IronGolem.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new HeroHurtByTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HeroHurtTargetGoal(this));
        this.f_21346_.m_25352_(5, (Goal)new DefendVillageGuardGoal(this));
        if (GuardConfig.AttackAllMobs) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, true, true, mob -> mob instanceof Enemy && !GuardConfig.MobBlackList.contains(mob.m_20078_())));
        } else {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Ravager.class, true));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Witch.class, true));
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
            this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true, mob -> !(mob instanceof NeutralMob)));
        }
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, true, true, mob -> ((List)GuardConfig.COMMON.MobWhiteList.get()).contains(mob.m_20078_())));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Guard)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        this.shieldCoolDown = 8;
        if (this.m_21205_().m_41720_() instanceof CrossbowItem) {
            this.m_32336_((LivingEntity)this, 1.6f);
        }
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            ItemStack hand = this.m_21205_();
            ItemStack itemstack = this.m_6298_(hand);
            AbstractArrow abstractarrowentity = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
            abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 0.0f);
            this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.m_9236_().m_7967_((Entity)abstractarrowentity);
            this.damageGuardItem(1, EquipmentSlot.MAINHAND, hand);
        }
        if (ModList.get().isLoaded("musketmod")) {
            ModCompat.shootGun(this);
        }
    }

    public void m_32336_(LivingEntity pUser, float pVelocity) {
        ItemStack stack = pUser.m_21205_();
        CrossbowItem.m_40887_((Level)pUser.m_9236_(), (LivingEntity)pUser, (InteractionHand)InteractionHand.MAIN_HAND, (ItemStack)stack, (float)pVelocity, (float)0.0f);
        this.m_5847_();
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
        super.m_8061_(slotIn, stack);
        switch (slotIn) {
            case CHEST: {
                if (!this.guardInventory.m_8020_(1).m_41619_()) break;
                this.guardInventory.m_6836_(1, (ItemStack)this.f_21351_.get(slotIn.m_20749_()));
                break;
            }
            case FEET: {
                if (!this.guardInventory.m_8020_(3).m_41619_()) break;
                this.guardInventory.m_6836_(3, (ItemStack)this.f_21351_.get(slotIn.m_20749_()));
                break;
            }
            case HEAD: {
                if (!this.guardInventory.m_8020_(0).m_41619_()) break;
                this.guardInventory.m_6836_(0, (ItemStack)this.f_21351_.get(slotIn.m_20749_()));
                break;
            }
            case LEGS: {
                if (!this.guardInventory.m_8020_(2).m_41619_()) break;
                this.guardInventory.m_6836_(2, (ItemStack)this.f_21351_.get(slotIn.m_20749_()));
                break;
            }
            case MAINHAND: {
                this.guardInventory.m_6836_(5, (ItemStack)this.f_21350_.get(slotIn.m_20749_()));
                break;
            }
            case OFFHAND: {
                this.guardInventory.m_6836_(4, (ItemStack)this.f_21350_.get(slotIn.m_20749_()));
            }
        }
    }

    public ItemStack m_6298_(ItemStack shootable) {
        if (shootable.m_41720_() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)shootable.m_41720_()).m_6442_();
            ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
            return itemstack.m_41619_() ? new ItemStack((ItemLike)Items.f_42412_) : itemstack;
        }
        return ItemStack.f_41583_;
    }

    public int getKickTicks() {
        return this.kickTicks;
    }

    public boolean isFollowing() {
        return (Boolean)this.f_19804_.m_135370_(FOLLOWING) != false && this.getOwner() != null;
    }

    public void setFollowing(boolean following) {
        this.f_19804_.m_135381_(FOLLOWING, (Object)following);
    }

    public boolean m_6779_(LivingEntity target) {
        return GuardConfig.MobBlackList.contains(target.m_20078_()) || target.m_21023_(MobEffects.f_19595_) || this.isOwner(target) ? false : super.m_6779_(target);
    }

    public void m_6083_() {
        super.m_6083_();
        if (this.m_20202_() instanceof PathfinderMob) {
            PathfinderMob creatureentity = (PathfinderMob)this.m_20202_();
            this.f_20883_ = creatureentity.f_20883_;
        }
    }

    public double m_6049_() {
        return -0.35;
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_6710_(LivingEntity entity) {
        TamableAnimal tamed;
        if (entity != null && (this.m_5647_() != null && entity.m_5647_() != null && this.m_5647_().m_83536_(entity.m_5647_()) || ((List)GuardConfig.COMMON.MobBlackList.get()).contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString()) || entity.m_21023_(MobEffects.f_19595_) || this.isOwner(entity) || entity instanceof TamableAnimal && (tamed = (TamableAnimal)entity).m_21805_() != null && tamed.m_21805_().equals(this.getOwnerId()))) {
            return;
        }
        super.m_6710_(entity);
    }

    public void gossip(Villager villager, long gameTime) {
        if (!(gameTime >= this.lastGossipTime && gameTime < this.lastGossipTime + 1200L || gameTime >= villager.f_35378_ && gameTime < villager.f_35378_ + 1200L)) {
            this.gossips.m_217762_(villager.m_35517_(), this.f_19796_, 10);
            this.lastGossipTime = gameTime;
            villager.f_35378_ = gameTime;
        }
    }

    public void m_5811_(LivingEntity arg0, ItemStack arg1, Projectile arg2, float arg3) {
        this.m_32322_((LivingEntity)this, arg0, arg2, arg3, 1.6f);
    }

    protected void m_6731_(LivingEntity entityIn) {
        if (this.isKicking()) {
            this.setKicking(false);
        }
        super.m_6731_((LivingEntity)this);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        boolean inventoryRequirements;
        boolean configValues = player.m_21023_(MobEffects.f_19595_) && GuardConfig.giveGuardStuffHOTV || player.m_21023_(MobEffects.f_19595_) && GuardConfig.setGuardPatrolHotv || player.m_21023_(MobEffects.f_19595_) && GuardConfig.giveGuardStuffHOTV && GuardConfig.setGuardPatrolHotv || this.getPlayerReputation(player) >= GuardConfig.reputationRequirement || player.m_21023_(MobEffects.f_19595_) && !GuardConfig.giveGuardStuffHOTV && !GuardConfig.setGuardPatrolHotv || this.getOwnerId() != null && this.getOwnerId().equals(player.m_20148_());
        boolean bl = inventoryRequirements = !player.m_36341_();
        if (inventoryRequirements) {
            if (this.m_5448_() != player && this.m_21515_() && configValues && player instanceof ServerPlayer) {
                this.openGui((ServerPlayer)player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public void m_6814_(ReputationEventType reputationEventType, Entity entity) {
    }

    public void m_5757_(Container invBasic) {
    }

    protected void m_6472_(DamageSource damageSource, float damage) {
        if (damage >= 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            for (int i = 0; i < this.guardInventory.m_6643_(); ++i) {
                ItemStack itemstack = this.guardInventory.m_8020_(i);
                if (damageSource.m_276093_(DamageTypes.f_268468_) && itemstack.m_41720_().m_41475_() || !(itemstack.m_41720_() instanceof ArmorItem)) continue;
                int j = i;
                this.damageGuardItem(1, EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)j), itemstack);
            }
        }
    }

    public void m_8038_(ServerLevel p_241841_1_, LightningBolt p_241841_2_) {
        if (p_241841_1_.m_46791_() != Difficulty.PEACEFUL && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20495_, timer -> {})) {
            Witch witchentity = (Witch)EntityType.f_20495_.m_20615_((Level)p_241841_1_);
            if (witchentity == null) {
                return;
            }
            witchentity.m_20359_((Entity)this);
            witchentity.m_6518_((ServerLevelAccessor)p_241841_1_, p_241841_1_.m_6436_(witchentity.m_20183_()), MobSpawnType.CONVERSION, null, null);
            witchentity.m_21557_(this.m_21525_());
            witchentity.m_6593_(this.m_7770_());
            witchentity.m_20340_(this.m_20151_());
            witchentity.m_21530_();
            p_241841_1_.m_47205_((Entity)witchentity);
            this.m_146870_();
        } else {
            super.m_8038_(p_241841_1_, p_241841_2_);
        }
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID arg0) {
        this.persistentAngerTarget = arg0;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int arg0) {
        this.remainingPersistentAngerTime = arg0;
    }

    public void m_6825_() {
        this.m_7870_(angerTime.m_214085_(this.f_19796_));
    }

    public void openGui(ServerPlayer player) {
        this.setOwnerId(player.m_20148_());
        if (player.f_36096_ != player.f_36095_) {
            player.m_6915_();
        }
        this.interacting = true;
        player.m_9217_();
        GuardPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new GuardOpenInventoryPacket(player.f_8940_, this.guardInventory.m_6643_(), this.m_19879_()));
        player.f_36096_ = new GuardContainer(player.f_8940_, player.m_150109_(), (Container)this.guardInventory, this);
        player.m_143399_(player.f_36096_);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.f_36096_));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public boolean isEating() {
        return GuardEatFoodGoal.isConsumable(this.m_21211_()) && this.m_6117_();
    }

    public boolean isPatrolling() {
        return (Boolean)this.f_19804_.m_135370_(PATROLLING);
    }

    public void setPatrolling(boolean patrolling) {
        this.f_19804_.m_135381_(PATROLLING, (Object)patrolling);
    }

    public boolean m_5886_(ProjectileWeaponItem item) {
        return item instanceof BowItem || item instanceof CrossbowItem || super.m_5886_(item);
    }

    public void tryToTeleportToOwner() {
        LivingEntity livingentity = this.getOwner();
        if (livingentity != null) {
            this.teleportToAroundBlockPos(livingentity.m_20183_());
        }
    }

    public boolean shouldTryTeleportToOwner() {
        LivingEntity livingentity = this.getOwner();
        return livingentity != null && this.m_20280_((Entity)this.getOwner()) >= 144.0 && (Boolean)GuardConfig.COMMON.guardTeleport.get() != false && this.m_5448_() == null;
    }

    private void teleportToAroundBlockPos(BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int j = this.f_19796_.m_216332_(-4, 4);
            int k = this.f_19796_.m_216332_(-4, 4);
            if (Math.abs(j) < 3 && Math.abs(k) < 3) continue;
            int l = this.f_19796_.m_216332_(-1, 1);
            if (!this.maybeTeleportTo(pos.m_123341_() + j, pos.m_123342_() + l, pos.m_123343_() + k)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.m_146908_(), this.m_146909_());
        this.f_21344_.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes pathtype = WalkNodeEvaluator.m_77604_((BlockGetter)this.m_9236_(), (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathtype != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.m_9236_().m_8055_(pos.m_7495_());
        if (blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.m_121996_((Vec3i)this.m_20183_());
        return this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82338_(blockpos));
    }

    public void damageGuardItem(int damage, EquipmentSlot slotToDamage, ItemStack item) {
        if (this.f_19796_.m_188501_() < ((Double)GuardConfig.COMMON.chanceToBreakEquipment.get()).floatValue()) {
            item.m_41622_(damage, (LivingEntity)this, entity -> entity.m_21166_(slotToDamage));
        }
    }

    public static class GuardMeleeGoal
    extends MeleeAttackGoal {
        public final Guard guard;

        public GuardMeleeGoal(Guard guard, double speedIn, boolean useLongMemory) {
            super((PathfinderMob)guard, speedIn, useLongMemory);
            this.guard = guard;
        }

        public boolean m_8036_() {
            return (!(this.f_25540_.m_21205_().m_41720_() instanceof CrossbowItem) || !(this.f_25540_.m_21205_().m_41720_() instanceof BowItem)) && this.guard.m_5448_() != null && !this.guard.isEating() && super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.guard.m_5448_() != null;
        }

        public void m_8037_() {
            LivingEntity target = this.guard.m_5448_();
            if (target != null) {
                if ((double)target.m_20270_((Entity)this.guard) <= 3.0) {
                    this.guard.m_21566_().m_24988_(-2.0f, 0.0f);
                    this.guard.m_21391_((Entity)target, 30.0f, 30.0f);
                }
                if (this.f_25543_ != null && (double)target.m_20270_((Entity)this.guard) <= 2.0) {
                    this.guard.m_21573_().m_26573_();
                }
                super.m_8037_();
            }
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return super.m_6639_(attackTarget) * 2.55;
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.f_25548_ <= 0) {
                this.m_25563_();
                this.guard.m_5810_();
                if (this.guard.shieldCoolDown == 0) {
                    this.guard.shieldCoolDown = 8;
                }
                this.guard.m_6674_(InteractionHand.MAIN_HAND);
                this.guard.m_7327_((Entity)enemy);
            }
        }
    }

    public static class FollowHeroGoal
    extends Goal {
        private final Guard guard;
        private LivingEntity owner;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;
        private float oldWaterCost;

        public FollowHeroGoal(Guard guard, double speedModifier, float startDistance, float stopDistance) {
            this.guard = guard;
            this.speedModifier = speedModifier;
            this.navigation = guard.m_21573_();
            this.startDistance = startDistance;
            this.stopDistance = stopDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.guard.getOwner();
            if (livingentity == null) {
                return false;
            }
            if (this.guard.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
                return false;
            }
            this.owner = livingentity;
            return this.guard.isFollowing();
        }

        public boolean m_8045_() {
            if (!this.navigation.m_26571_()) {
                return this.guard.m_20280_((Entity)this.owner) >= (double)(this.stopDistance * this.stopDistance) && this.guard.isFollowing();
            }
            return false;
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.guard.m_21439_(BlockPathTypes.WATER);
            this.guard.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            this.owner = null;
            this.navigation.m_26573_();
            this.guard.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            boolean shouldTryTeleportToOwner = this.guard.shouldTryTeleportToOwner();
            if (!shouldTryTeleportToOwner) {
                this.guard.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.guard.m_8132_());
            }
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                if (shouldTryTeleportToOwner) {
                    this.guard.tryToTeleportToOwner();
                } else {
                    this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    public static class DefendVillageGuardGoal
    extends TargetGoal {
        private final Guard guard;
        private LivingEntity villageAggressorTarget;

        public DefendVillageGuardGoal(Guard guardIn) {
            super((Mob)guardIn, true, true);
            this.guard = guardIn;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            AABB axisalignedbb = this.guard.m_20191_().m_82377_(10.0, 8.0, 10.0);
            List list = this.guard.m_9236_().m_45976_(Villager.class, axisalignedbb);
            List list1 = this.guard.m_9236_().m_45976_(Player.class, axisalignedbb);
            for (Villager villager : list) {
                for (Player player : list1) {
                    int i = villager.m_35532_(player);
                    if (i > (Integer)GuardConfig.COMMON.reputationRequirementToBeAttacked.get()) continue;
                    this.villageAggressorTarget = player;
                    if (this.villageAggressorTarget.m_5647_() == null || this.guard.m_5647_() == null || !this.guard.m_5647_().m_83536_(this.villageAggressorTarget.m_5647_())) continue;
                    return false;
                }
            }
            return this.villageAggressorTarget != null && !this.villageAggressorTarget.m_21023_(MobEffects.f_19595_) && !this.villageAggressorTarget.m_5833_() && !((Player)this.villageAggressorTarget).m_7500_();
        }

        public void m_8056_() {
            this.guard.m_6710_(this.villageAggressorTarget);
            super.m_8056_();
        }
    }
}

