/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.inventories;

import net.mehvahdjukaar.supplementaries.reg.ModMenuTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.ClientSideMerchant;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.MerchantResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public class RedMerchantMenu
extends AbstractContainerMenu {
    private final Merchant trader;
    private final MerchantContainer tradeContainer;
    private int merchantLevel;
    private boolean showProgressBar;
    private boolean canRestock;

    public RedMerchantMenu(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory);
    }

    public RedMerchantMenu(int i, Inventory inventory) {
        this(i, inventory, (Merchant)new ClientSideMerchant(inventory.f_35978_));
    }

    public RedMerchantMenu(int i, Inventory inventory, Merchant merchant) {
        super(ModMenuTypes.RED_MERCHANT.get(), i);
        int j;
        this.trader = merchant;
        this.tradeContainer = new MerchantContainer(merchant);
        this.m_38897_(new Slot((Container)this.tradeContainer, 0, 136, 37));
        this.m_38897_(new Slot((Container)this.tradeContainer, 1, 162, 37));
        this.m_38897_((Slot)new MerchantResultSlot(inventory.f_35978_, merchant, this.tradeContainer, 2, 220, 37));
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)inventory, k + j * 9 + 9, 108 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)inventory, j, 108 + j * 18, 142));
        }
    }

    public void setShowProgressBar(boolean showProgressBar) {
        this.showProgressBar = showProgressBar;
    }

    public void m_6199_(Container container) {
        this.tradeContainer.m_40024_();
        super.m_6199_(container);
    }

    public void setSelectionHint(int currentRecipeIndex) {
        this.tradeContainer.m_40020_(currentRecipeIndex);
    }

    public boolean m_6875_(Player player) {
        return this.trader.m_7962_() == player;
    }

    public int getTraderXp() {
        return this.trader.m_7809_();
    }

    public int getFutureTraderXp() {
        return this.tradeContainer.m_40026_();
    }

    public void setXp(int xp) {
        this.trader.m_6621_(xp);
    }

    public int getTraderLevel() {
        return this.merchantLevel;
    }

    public void setMerchantLevel(int level) {
        this.merchantLevel = level;
    }

    public void setCanRestock(boolean canRestock) {
        this.canRestock = canRestock;
    }

    public boolean canRestock() {
        return this.canRestock;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return false;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            itemStack = itemStack2.m_41777_();
            if (index == 2) {
                if (!this.m_38903_(itemStack2, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemStack2, itemStack);
                this.playTradeSound();
            } else if (index != 0 && index != 1 ? (index >= 3 && index < 30 ? !this.m_38903_(itemStack2, 30, 39, false) : index >= 30 && index < 39 && !this.m_38903_(itemStack2, 3, 30, false)) : !this.m_38903_(itemStack2, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
        }
        return itemStack;
    }

    private void playTradeSound() {
        if (!this.trader.m_183595_()) {
            Entity entity = (Entity)this.trader;
            entity.m_9236_().m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.trader.m_7596_(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.trader.m_7189_((Player)null);
        if (!this.trader.m_183595_()) {
            ServerPlayer sp;
            if (!player.m_6084_() || player instanceof ServerPlayer && (sp = (ServerPlayer)player).m_9232_()) {
                ItemStack itemStack = this.tradeContainer.m_8016_(0);
                if (!itemStack.m_41619_()) {
                    player.m_36176_(itemStack, false);
                }
                if (!(itemStack = this.tradeContainer.m_8016_(1)).m_41619_()) {
                    player.m_36176_(itemStack, false);
                }
            } else if (player instanceof ServerPlayer) {
                player.m_150109_().m_150079_(this.tradeContainer.m_8016_(0));
                player.m_150109_().m_150079_(this.tradeContainer.m_8016_(1));
            }
        }
    }

    public void tryMoveItems(int selectedMerchantRecipe) {
        if (selectedMerchantRecipe >= 0 && this.getOffers().size() > selectedMerchantRecipe) {
            ItemStack itemStack2;
            ItemStack itemStack = this.tradeContainer.m_8020_(0);
            if (!itemStack.m_41619_()) {
                if (!this.m_38903_(itemStack, 3, 39, true)) {
                    return;
                }
                this.tradeContainer.m_6836_(0, itemStack);
            }
            if (!(itemStack2 = this.tradeContainer.m_8020_(1)).m_41619_()) {
                if (!this.m_38903_(itemStack2, 3, 39, true)) {
                    return;
                }
                this.tradeContainer.m_6836_(1, itemStack2);
            }
            if (this.tradeContainer.m_8020_(0).m_41619_() && this.tradeContainer.m_8020_(1).m_41619_()) {
                ItemStack itemStack3 = ((MerchantOffer)this.getOffers().get(selectedMerchantRecipe)).m_45358_();
                this.moveFromInventoryToPaymentSlot(0, itemStack3);
                ItemStack itemStack4 = ((MerchantOffer)this.getOffers().get(selectedMerchantRecipe)).m_45364_();
                this.moveFromInventoryToPaymentSlot(1, itemStack4);
            }
        }
    }

    private void moveFromInventoryToPaymentSlot(int paymentSlotIndex, ItemStack paymentSlot) {
        if (!paymentSlot.m_41619_()) {
            for (int i = 3; i < 39; ++i) {
                ItemStack itemStack = ((Slot)this.f_38839_.get(i)).m_7993_();
                if (itemStack.m_41619_() || !ItemStack.m_150942_((ItemStack)paymentSlot, (ItemStack)itemStack)) continue;
                ItemStack itemStack2 = this.tradeContainer.m_8020_(paymentSlotIndex);
                int j = itemStack2.m_41619_() ? 0 : itemStack2.m_41613_();
                int k = Math.min(paymentSlot.m_41741_() - j, itemStack.m_41613_());
                ItemStack itemStack3 = itemStack.m_41777_();
                int l = j + k;
                itemStack.m_41774_(k);
                itemStack3.m_41764_(l);
                this.tradeContainer.m_6836_(paymentSlotIndex, itemStack3);
                if (l >= paymentSlot.m_41741_()) break;
            }
        }
    }

    public void setOffers(MerchantOffers offers) {
        this.trader.m_6255_(offers);
    }

    public MerchantOffers getOffers() {
        return this.trader.m_6616_();
    }

    public boolean showProgressBar() {
        return this.showProgressBar;
    }
}

