/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.render.feature;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.api.DoApiAPI;
import de.cristelknight.doapi.api.DoApiPlugin;
import de.cristelknight.doapi.common.item.ICustomHat;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@Deprecated
public class CustomHatFeatureRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public final Map<Item, EntityModel<T>> MODELS = Maps.newHashMap();
    private final EntityModelSet modelLoader;
    private final float yOffset;

    public CustomHatFeatureRenderer(RenderLayerParent<T, M> context, EntityModelSet modelSet) {
        this(context, modelSet, 0.0f);
    }

    public CustomHatFeatureRenderer(RenderLayerParent<T, M> context, EntityModelSet modelLoader, float yOffset) {
        super(context);
        this.yOffset = yOffset;
        this.modelLoader = modelLoader;
    }

    public EntityModel<T> getHatModel(T entity, EquipmentSlot slot) {
        ICustomHat hatItem = this.getHat(entity, slot);
        if (hatItem instanceof Item) {
            Item item = (Item)hatItem;
            if (this.MODELS.isEmpty()) {
                List<DoApiAPI> apis = Util.getApis(DoApiAPI.class, "doapi", DoApiPlugin.class);
                for (DoApiAPI api : apis) {
                    api.registerHat(this.MODELS, this.modelLoader);
                }
            }
            return this.MODELS.get(item);
        }
        return null;
    }

    public ICustomHat getHat(T entity, EquipmentSlot slot) {
        ItemStack headSlot = entity.m_6844_(slot);
        Item item = headSlot.m_41720_();
        if (item instanceof ICustomHat) {
            ICustomHat hat = (ICustomHat)item;
            if (!headSlot.m_41619_()) {
                return hat;
            }
        }
        return null;
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        EquipmentSlot[] slots;
        for (EquipmentSlot slot : slots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            Item item;
            EntityModel<T> headModel = this.getHatModel(entity, slot);
            ItemStack hatStack = entity.m_6844_(slot);
            if (headModel == null || !((item = hatStack.m_41720_()) instanceof ICustomHat)) continue;
            ICustomHat hatItem = (ICustomHat)item;
            matrices.m_85836_();
            this.setupHat(matrices, slot, hatItem.getOffset().floatValue());
            VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)vertexConsumers, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTexture(entity, slot)), (boolean)false, (boolean)hatStack.m_41790_());
            if (hatItem instanceof DyeableArmorItem) {
                DyeableArmorItem dyeableArmorItem = (DyeableArmorItem)hatItem;
                int j = dyeableArmorItem.m_41121_(hatStack);
                float f = (float)(j >> 16 & 0xFF) / 255.0f;
                float g = (float)(j >> 8 & 0xFF) / 255.0f;
                float h = (float)(j & 0xFF) / 255.0f;
                headModel.m_7695_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, f, g, h, 1.0f);
            } else {
                headModel.m_7695_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrices.m_85849_();
        }
    }

    public void setupHat(PoseStack matrices, EquipmentSlot slot, float extraYOffset) {
        if (slot == EquipmentSlot.HEAD) {
            ((HeadedModel)this.m_117386_()).m_5585_().m_104299_(matrices);
        }
        matrices.m_85841_(1.0f, 1.0f, 1.0f);
        matrices.m_252880_(0.0f, this.yOffset + extraYOffset, 0.0f);
    }

    protected ResourceLocation getTexture(T entity, EquipmentSlot slot) {
        ICustomHat customItem = this.getHat(entity, slot);
        if (customItem != null) {
            return customItem.getTexture();
        }
        return super.m_117347_(entity);
    }
}

