/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.core.misc.DummyWorld;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.common.block.tiles.OpeneableContainerBlockEntity;
import net.mehvahdjukaar.supplementaries.common.entities.SlingshotProjectileEntity;
import net.mehvahdjukaar.supplementaries.common.inventories.CannonContainerMenu;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class CannonBlockTile
extends OpeneableContainerBlockEntity {
    private static final int TIME_TO_FIRE = 40;
    private static final int FIRE_COOLDOWN = 60;
    private float pitch = 0.0f;
    private float prevPitch = 0.0f;
    private float yaw = 0.0f;
    private float prevYaw = 0.0f;
    private float cooldown = 0.0f;
    private float chargeTimer = 0.0f;
    private byte firePower = 1;
    private float projectileDrag = 0.0f;
    private float projectileGravity = 0.0f;
    private static final GameProfile FAKE_PLAYER = new GameProfile(UUID.fromString("11242C44-14d5-1f22-3d27-13D2C45CA355"), "[CANNON_TESTER]");

    public CannonBlockTile(BlockPos pos, BlockState blockState) {
        super(null, pos, blockState, 2);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("yaw", this.yaw);
        tag.m_128350_("pitch", this.pitch);
        tag.m_128350_("cooldown", this.cooldown);
        tag.m_128350_("fire_timer", this.chargeTimer);
        tag.m_128344_("fire_power", this.firePower);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.yaw = tag.m_128457_("yaw");
        this.pitch = tag.m_128457_("pitch");
        this.cooldown = tag.m_128457_("cooldown");
        this.chargeTimer = tag.m_128457_("fire_timer");
        this.firePower = tag.m_128445_("fire_power");
        if (this.f_58857_ != null) {
            this.recalculateProjectileStats();
        }
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            this.recalculateProjectileStats();
        }
    }

    public boolean readyToFire() {
        return this.cooldown == 0.0f && this.chargeTimer == 0.0f && this.hasFuelAndProjectiles();
    }

    public boolean hasFuelAndProjectiles() {
        return !this.getProjectile().m_41619_() && !this.getFuel().m_41619_() && this.getFuel().m_41613_() >= this.firePower;
    }

    public float getCooldown() {
        return this.cooldown;
    }

    public float getFireTimer() {
        return this.chargeTimer;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public ItemStack getProjectile() {
        return this.m_8020_(1).m_255036_(1);
    }

    public ItemStack getFuel() {
        return this.m_8020_(0);
    }

    public float getProjectileDrag() {
        return this.projectileDrag;
    }

    public float getProjectileGravity() {
        return this.projectileGravity;
    }

    public byte getFirePower() {
        return this.firePower;
    }

    public float getYaw(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevYaw, (float)this.yaw);
    }

    public float getPitch(float partialTicks) {
        return Mth.m_14189_((float)partialTicks, (float)this.prevPitch, (float)this.pitch);
    }

    public void syncAttributes(float yaw, float pitch, byte firePower, boolean fire) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.firePower = firePower;
        if (fire) {
            this.ignite();
        }
    }

    public void setPitch(float pitch) {
        this.pitch = Mth.m_14177_((float)pitch);
    }

    public void setYaw(float yaw) {
        this.yaw = Mth.m_14177_((float)yaw);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"gui.supplementaries.cannon");
    }

    public AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new CannonContainerMenu(id, player, this);
    }

    @Override
    protected void updateBlockState(BlockState state, boolean b) {
    }

    @Override
    protected void playOpenSound(BlockState state) {
    }

    @Override
    protected void playCloseSound(BlockState state) {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 0) {
            return stack.m_150930_(Items.f_42403_);
        }
        return true;
    }

    public boolean m_7155_(int index, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(direction == null || direction.m_122434_().m_122479_() ? 1 : 0, itemStack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    @Override
    public int[] m_7071_(Direction side) {
        return new int[]{side.m_122434_().m_122479_() ? 1 : 0};
    }

    public void use(Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_36341_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
            } else {
                CannonController.activateCannonCamera(this);
            }
        } else if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PlatHelper.openCustomMenu((ServerPlayer)sp, (MenuProvider)this, (BlockPos)this.f_58858_);
        }
    }

    public void ignite() {
        this.f_58857_.m_5594_(null, this.f_58858_, ModSounds.GUNPOWDER_IGNITE.get(), SoundSource.BLOCKS, 1.0f, 1.8f + this.f_58857_.m_213780_().m_188501_() * 0.2f);
        this.chargeTimer = 1.0f;
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CannonBlockTile t) {
        t.prevYaw = t.yaw;
        t.prevPitch = t.pitch;
        if (t.cooldown > 0.0f) {
            t.cooldown -= 0.016666668f;
            if (t.cooldown < 0.0f) {
                t.cooldown = 0.0f;
            }
        }
        if (t.chargeTimer > 0.0f) {
            t.chargeTimer -= 0.025f;
            if (t.chargeTimer <= 0.0f) {
                t.chargeTimer = 0.0f;
                t.fire();
            }
        }
    }

    public void fire() {
        if (this.f_58857_.f_46443_) {
            BlockPos pos = this.f_58858_;
            this.f_58857_.m_7106_((ParticleOptions)ModParticles.CANNON_FIRE_PARTICLE.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(this.pitch * ((float)Math.PI / 180)), (double)(-this.yaw * ((float)Math.PI / 180)), 0.0);
            PoseStack poseStack = new PoseStack();
            RandomSource ran = this.f_58857_.f_46441_;
            poseStack.m_252880_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.5f + 0.0625f, (float)pos.m_123343_() + 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-this.yaw));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(this.pitch));
            poseStack.m_85837_(0.0, 0.0, -1.4);
            this.spawnDustRing(poseStack);
            this.spawnSmokeTrail(poseStack, ran);
        } else {
            this.shootProjectile();
        }
        this.cooldown = 1.0f;
    }

    private boolean shootProjectile() {
        BlockPos pos = this.f_58858_;
        Vec3 facing = Vec3.m_82498_((float)this.pitch, (float)this.yaw).m_82490_(0.01);
        ItemStack projectile = this.getProjectile();
        Entity proj = CannonBlockTile.getProjectileFromItemHack(this.f_58857_, projectile);
        if (proj instanceof Projectile) {
            Projectile arrow = (Projectile)proj;
            arrow.f_150163_ = null;
            arrow.f_37244_ = null;
            CompoundTag c = new CompoundTag();
            arrow.m_20223_(c);
            Optional opt = EntityType.m_20642_((CompoundTag)c, (Level)this.f_58857_);
            if (opt.isPresent()) {
                arrow = (Projectile)opt.get();
                arrow.m_6034_((double)pos.m_123341_() + 0.5 - facing.f_82479_, (double)pos.m_123342_() + 0.5 - facing.f_82480_, (double)pos.m_123343_() + 0.5 - facing.f_82481_);
                float inaccuracy = 0.0f;
                float power = -this.projectileDrag * (float)this.getFirePower();
                arrow.m_6686_(facing.f_82479_, facing.f_82480_, facing.f_82481_, power, inaccuracy);
                this.f_58857_.m_7967_((Entity)arrow);
                return true;
            }
        }
        return false;
    }

    private void spawnSmokeTrail(PoseStack poseStack, RandomSource ran) {
        int smokeCount = 20;
        for (int i = 0; i < smokeCount; ++i) {
            poseStack.m_85836_();
            Vector4f speed = poseStack.m_85850_().m_252922_().transform(new Vector4f(0.0f, 0.0f, -MthUtils.nextWeighted((RandomSource)ran, (float)0.5f, (float)1.0f, (float)0.06f), 0.0f));
            float aperture = 0.5f;
            poseStack.m_252880_(-aperture / 2.0f + ran.m_188501_() * aperture, -aperture / 2.0f + ran.m_188501_() * aperture, 0.0f);
            Vector4f p = poseStack.m_85850_().m_252922_().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)p.x, (double)p.y, (double)p.z, (double)speed.x, (double)speed.y, (double)speed.z);
            poseStack.m_85849_();
        }
    }

    private void spawnDustRing(PoseStack poseStack) {
        poseStack.m_85836_();
        Vector4f p = poseStack.m_85850_().m_252922_().transform(new Vector4f(0.0f, 0.0f, 1.0f, 1.0f));
        int dustCount = 16;
        for (int i = 0; i < dustCount; ++i) {
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(380.0f * (float)i / (float)dustCount));
            Vector4f speed = poseStack.m_85850_().m_252922_().transform(new Vector4f(0.0f, 0.0f, 0.05f, 0.0f));
            this.f_58857_.m_7106_((ParticleOptions)ModParticles.BOMB_SMOKE_PARTICLE.get(), (double)p.x, (double)p.y, (double)p.z, (double)speed.x, (double)speed.y, (double)speed.z);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private static Entity getProjectileFromItemHack(Level level, ItemStack projectile) {
        Player fakePlayer = FakePlayerManager.get((GameProfile)FAKE_PLAYER, (Level)level);
        Item item = projectile.m_41720_();
        if (item instanceof ArrowItem) {
            ArrowItem ai = (ArrowItem)item;
            return ai.m_6394_(level, projectile, (LivingEntity)fakePlayer);
        }
        ProjectileTestLevel testLevel = (ProjectileTestLevel)ProjectileTestLevel.getCachedInstance((String)"cannon_test_level", ProjectileTestLevel::new);
        testLevel.setup();
        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, projectile.m_41777_());
        projectile.m_41682_((Level)testLevel, fakePlayer, InteractionHand.MAIN_HAND);
        Entity p = testLevel.projectile;
        if (p != null) {
            return p;
        }
        if (projectile.m_150930_(Items.f_42613_)) {
            return EntityType.f_20527_.m_20615_(level);
        }
        return new SlingshotProjectileEntity(level, projectile, ItemStack.f_41583_);
    }

    private void recalculateProjectileStats() {
        ItemStack projectile = this.getProjectile();
        if (projectile.m_41619_()) {
            return;
        }
        Entity proj = CannonBlockTile.getProjectileFromItemHack(this.f_58857_, projectile);
        proj.m_20334_(1.0, 0.0, 0.0);
        proj.m_8119_();
        Vec3 newMovement = proj.m_20184_();
        this.projectileDrag = (float)newMovement.f_82479_;
        this.projectileGravity = (float)(-newMovement.f_82480_);
    }

    private static class ProjectileTestLevel
    extends DummyWorld {
        private Entity projectile = null;

        public ProjectileTestLevel() {
            super(false, false);
        }

        public void setup() {
            this.projectile = null;
        }

        public boolean m_7967_(Entity entity) {
            this.projectile = entity;
            return true;
        }
    }
}

