/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.net;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.common.blockentity.special.FramedSignBlockEntity;

public record SignUpdatePacket(BlockPos pos, boolean front, String[] lines) {
    public static SignUpdatePacket decode(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.m_130135_();
        boolean front = buffer.readBoolean();
        int count = buffer.readByte();
        String[] lines = new String[count];
        for (int i = 0; i < count; ++i) {
            lines[i] = buffer.m_130136_(384);
        }
        return new SignUpdatePacket(pos, front, lines);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeBoolean(this.front);
        buffer.writeByte(this.lines.length);
        for (String line : this.lines) {
            buffer.m_130070_(line);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = Objects.requireNonNull(ctx.get().getSender());
        List<String> strippedLines = Stream.of(this.lines).map(ChatFormatting::m_126649_).toList();
        player.f_8906_.m_243065_(strippedLines).thenAccept(filteredText -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
            BlockEntity patt1809$temp;
            Level level = player.m_9236_();
            if (level.m_46805_(this.pos) && (patt1809$temp = level.m_7702_(this.pos)) instanceof FramedSignBlockEntity) {
                FramedSignBlockEntity sign = (FramedSignBlockEntity)patt1809$temp;
                if (sign.isWaxed() || !player.m_20148_().equals(sign.getEditingPlayer())) {
                    FramedBlocks.LOGGER.warn("Player {} just tried to change non-editable sign at", (Object)player.m_7755_().getString(), (Object)this.pos);
                    return;
                }
                player.m_9243_();
                sign.updateTextFromPacket((Player)player, this.front, (List<FilteredText>)filteredText);
            }
        }));
        return true;
    }
}

