/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.doubled;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.slab.FramedAdjustableDoubleBlock;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleCopycatBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.ICollapsibleCopycatBlockEntity;

public class FramedAdjustableDoubleBlockEntity
extends FramedDoubleBlockEntity
implements ICollapsibleCopycatBlockEntity {
    private static final int MIN_PART_HEIGHT = 1;
    private static final int MAX_PART_HEIGHT = 15;
    public static final int CENTER_PART_HEIGHT = 8;
    private final ModelProperty<Integer> offsetProperty;
    private final OffsetPacker offsetPacker;
    private int firstHeight = 8;

    private FramedAdjustableDoubleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, ModelProperty<Integer> offsetProperty, OffsetPacker offsetPacker) {
        super(type, pos, state);
        this.offsetProperty = offsetProperty;
        this.offsetPacker = offsetPacker;
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit) {
        Direction facing = FramedAdjustableDoubleBlockEntity.getFacing(this.m_58900_());
        Direction face = hit.m_82434_();
        if (face == facing.m_122424_()) {
            return false;
        }
        if (face == facing) {
            return true;
        }
        int y = (int)(Utils.fractionInDir(hit.m_82450_(), facing) * 16.0);
        return y > this.firstHeight;
    }

    public boolean handleDeform(Player player) {
        HitResult hit = player.m_19907_(10.0, 1.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult blockHit = (BlockHitResult)hit;
        Direction facing = FramedAdjustableDoubleBlockEntity.getFacing(this.m_58900_());
        Direction faceHit = blockHit.m_82434_();
        if (faceHit.m_122434_() != facing.m_122434_()) {
            return false;
        }
        if (!this.f_58857_.m_5776_()) {
            boolean upwards = faceHit == facing.m_122424_() ^ player.m_6144_();
            boolean changed = false;
            if (!upwards && this.firstHeight > 1) {
                --this.firstHeight;
                changed = true;
            } else if (upwards && this.firstHeight < 15) {
                ++this.firstHeight;
                changed = true;
            }
            if (changed) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                this.m_6596_();
            }
        }
        return true;
    }

    @Override
    public int getFaceOffset(BlockState state, Direction side) {
        Direction facing = FramedAdjustableDoubleBlockEntity.getFacing(this.m_58900_());
        Tuple<BlockState, BlockState> blockPair = this.getBlockPair();
        if (state == blockPair.m_14418_() && side == facing) {
            return 16 - this.firstHeight;
        }
        if (state == blockPair.m_14419_() && side == facing.m_122424_()) {
            return this.firstHeight;
        }
        return 0;
    }

    @Override
    public int getPackedOffsets(BlockState state) {
        Tuple<BlockState, BlockState> blockPair = this.getBlockPair();
        if (state == blockPair.m_14418_()) {
            return this.offsetPacker.pack(this.m_58900_(), this.firstHeight, false);
        }
        if (state == blockPair.m_14419_()) {
            return this.offsetPacker.pack(this.m_58900_(), this.firstHeight, true);
        }
        return 0;
    }

    @Override
    public ModelData getModelData() {
        BlockState state = this.m_58900_();
        ModelData data = super.getModelData();
        ModelData dataLeft = Objects.requireNonNull((ModelData)data.get(DATA_LEFT)).derive().with(this.offsetProperty, (Object)this.offsetPacker.pack(state, this.firstHeight, false)).build();
        ModelData dataRight = Objects.requireNonNull((ModelData)data.get(DATA_RIGHT)).derive().with(this.offsetProperty, (Object)this.offsetPacker.pack(state, this.firstHeight, true)).build();
        return data.derive().with(DATA_LEFT, (Object)dataLeft).with(DATA_RIGHT, (Object)dataRight).build();
    }

    private static Direction getFacing(BlockState state) {
        return ((FramedAdjustableDoubleBlock)state.m_60734_()).getFacing(state);
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt) {
        super.writeToDataPacket(nbt);
        nbt.m_128405_("first_height", this.firstHeight);
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt) {
        boolean needUpdate = super.readFromDataPacket(nbt);
        int height = nbt.m_128451_("first_height");
        if (height != this.firstHeight) {
            this.firstHeight = height;
            needUpdate = true;
            this.updateCulling(true, false);
        }
        return needUpdate;
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("first_height", this.firstHeight);
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        this.firstHeight = nbt.m_128451_("first_height");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("first_height", this.firstHeight);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.firstHeight = nbt.m_128451_("first_height");
    }

    public static FramedAdjustableDoubleBlockEntity standard(BlockPos pos, BlockState state) {
        return new FramedAdjustableDoubleBlockEntity(FBContent.BE_TYPE_FRAMED_ADJ_DOUBLE_BLOCK.get(), pos, state, FramedCollapsibleBlockEntity.OFFSETS, FramedAdjustableDoubleBlockEntity::getPackedOffsetsStandard);
    }

    public static FramedAdjustableDoubleBlockEntity copycat(BlockPos pos, BlockState state) {
        return new FramedAdjustableDoubleBlockEntity(FBContent.BE_TYPE_FRAMED_ADJ_DOUBLE_COPYCAT_BLOCK.get(), pos, state, FramedCollapsibleCopycatBlockEntity.OFFSETS, FramedAdjustableDoubleBlockEntity::getPackedOffsetsCopycat);
    }

    public static int getPackedOffsetsStandard(BlockState state, int firstHeight, boolean right) {
        if (!right) {
            firstHeight = 16 - firstHeight;
        }
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result |= firstHeight << i * 5;
        }
        return result;
    }

    public static int getPackedOffsetsCopycat(BlockState state, int firstHeight, boolean right) {
        Direction facing = FramedAdjustableDoubleBlockEntity.getFacing(state);
        if (right) {
            facing = facing.m_122424_();
        } else {
            firstHeight = 16 - firstHeight;
        }
        return firstHeight << facing.ordinal() * 4;
    }

    public static interface OffsetPacker {
        public int pack(BlockState var1, int var2, boolean var3);
    }
}

