/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.shapes;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.shapes.ReloadableShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeCache;

@ApiStatus.Internal
public final class ShapeReloader
implements ResourceManagerReloadListener {
    public static final ShapeReloader INSTANCE = new ShapeReloader();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<ShapeCache<?>> CACHES = new ArrayList();
    private static final List<ReloadableShapeProvider> PROVIDERS = new ArrayList<ReloadableShapeProvider>();

    private ShapeReloader() {
    }

    static synchronized void addCache(ShapeCache<?> cache) {
        CACHES.add(cache);
    }

    static synchronized void addProvider(ReloadableShapeProvider provider) {
        PROVIDERS.add(provider);
    }

    public void m_6213_(ResourceManager resourceManager) {
        LOGGER.info("Reloading {} caches and {} reloadable shape providers...", (Object)CACHES.size(), (Object)PROVIDERS.size());
        Stopwatch watch = Stopwatch.createStarted();
        try {
            CACHES.forEach(ShapeCache::reload);
            PROVIDERS.forEach(ReloadableShapeProvider::reload);
        }
        catch (Throwable t) {
            LogUtils.getLogger().error("Encountered an error while reloading shapes", t);
        }
        watch.stop();
        LOGGER.info("{} caches and {} reloadable shape providers reloaded, took {}", new Object[]{CACHES.size(), PROVIDERS.size(), watch});
    }
}

