/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.util;

import einstein.subtle_effects.configs.ModBlockConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPacket;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.particle.option.ColorParticleOptions;
import einstein.subtle_effects.particle.option.DirectionParticleOptions;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.Box;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ParticleSpawnUtil {
    public static void spawnSparks(Level level, RandomSource random, BlockPos pos, SparkType sparkType, Box box, Vec3 maxSpeeds, int count, List<Integer> colors) {
        if (random.m_188499_()) {
            Vec3 start = box.min();
            Vec3 end = box.max();
            for (int i = 0; i < count; ++i) {
                level.m_7106_((ParticleOptions)SparkParticle.create(sparkType, random, colors), (double)pos.m_123341_() + Mth.m_216263_((RandomSource)random, (double)start.f_82479_, (double)end.f_82479_), (double)pos.m_123342_() + Mth.m_216263_((RandomSource)random, (double)start.f_82480_, (double)end.f_82480_), (double)pos.m_123343_() + Mth.m_216263_((RandomSource)random, (double)start.f_82481_, (double)end.f_82481_), MathUtil.nextNonAbsDouble(random, maxSpeeds.m_7096_()), MathUtil.nextNonAbsDouble(random, maxSpeeds.m_7098_()), MathUtil.nextNonAbsDouble(random, maxSpeeds.m_7094_()));
            }
        }
    }

    public static void spawnParticlesAroundBlock(ParticleOptions particle, Level level, BlockPos pos, RandomSource random, int perSideChance) {
        ParticleSpawnUtil.spawnParticlesAroundBlock(particle, level, pos, random, 0.0625f, perSideChance > 0 ? direction -> random.m_188503_(perSideChance) != 0 : null);
    }

    public static void spawnParticlesAroundBlock(ParticleOptions particle, Level level, BlockPos pos, RandomSource random, float offset, @Nullable Predicate<Direction> predicate) {
        for (Direction direction : Direction.values()) {
            if (predicate != null && predicate.test(direction)) {
                return;
            }
            BlockPos relativePos = pos.m_121945_(direction);
            if (level.m_8055_(relativePos).m_60804_((BlockGetter)level, relativePos)) continue;
            ParticleSpawnUtil.spawnParticlesOnSide(particle, offset, direction, level, pos, random, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnParticlesOnSide(ParticleOptions particle, float offset, Direction direction, Level level, BlockPos pos, RandomSource random, double xSpeed, double ySpeed, double zSpeed) {
        double offsetFromCenter = 0.5 + (double)offset;
        Direction.Axis axis = direction.m_122434_();
        double xOffset = axis == Direction.Axis.X ? 0.5 + offsetFromCenter * (double)direction.m_122429_() : (double)random.m_188501_();
        double yOffset = axis == Direction.Axis.Y ? 0.5 + offsetFromCenter * (double)direction.m_122430_() : (double)random.m_188501_();
        double zOffset = axis == Direction.Axis.Z ? 0.5 + offsetFromCenter * (double)direction.m_122431_() : (double)random.m_188501_();
        level.m_7106_(particle, (double)pos.m_123341_() + xOffset, (double)pos.m_123342_() + yOffset, (double)pos.m_123343_() + zOffset, xSpeed, ySpeed, zSpeed);
    }

    public static void spawnFallDustClouds(LivingEntity entity, float distance, int fallDamage, ClientBoundEntityFellPacket.TypeConfig config) {
        Level level = entity.m_9236_();
        if (level.f_46443_ && entity.equals((Object)Minecraft.m_91087_().f_91074_)) {
            ParticleSpawnUtil.spawnEntityFellParticles(entity, entity.m_20186_(), distance, fallDamage, ModConfigs.ENTITIES.dustClouds.playerFell);
        } else if (level instanceof ServerLevel) {
            ServerPlayer player;
            ServerLevel serverLevel = (ServerLevel)level;
            Services.NETWORK.sendToClientsTracking(entity instanceof ServerPlayer ? (player = (ServerPlayer)entity) : null, serverLevel, entity.m_20183_(), new ClientBoundEntityFellPacket(entity.m_19879_(), entity.m_20186_(), distance, fallDamage, config));
        }
    }

    public static void spawnCreatureMovementDustClouds(LivingEntity entity, Level level, RandomSource random, int YSpeedModifier) {
        if (ModConfigs.ENTITIES.dustClouds.mobRunning) {
            ParticleSpawnUtil.spawnCreatureMovementDustCloudsNoConfig(entity, level, random, YSpeedModifier);
        }
    }

    public static void spawnCreatureMovementDustCloudsNoConfig(LivingEntity entity, Level level, RandomSource random, int YSpeedModifier) {
        if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.m_46758_(entity.m_20183_())) {
            return;
        }
        if (entity.m_20145_()) {
            return;
        }
        level.m_7106_((ParticleOptions)ModParticles.LARGE_DUST_CLOUD.get(), entity.m_20182_().f_82479_ + (double)entity.m_20205_() * random.m_188500_() - 1.0, entity.m_20186_() + Math.max(Math.min((double)random.m_188501_(), 0.5), 0.2), entity.m_20182_().f_82481_ + (double)entity.m_20205_() * random.m_188500_() - 1.0, 0.0, random.m_188500_() * (double)YSpeedModifier, 0.0);
    }

    public static void spawnCmdBlockParticles(Level level, Vec3 pos, RandomSource random, BiPredicate<Direction, Vec3> directionValidator) {
        for (Direction direction : Direction.values()) {
            Vec3 endPos = pos.m_231075_(direction, 1.0);
            Vec3 relativePos = endPos.m_231075_(direction, -0.5);
            if (!directionValidator.test(direction, endPos)) continue;
            Vec3 speed = pos.m_82505_(relativePos).m_272010_(random, 1.0f);
            level.m_7106_((ParticleOptions)new DirectionParticleOptions(ModParticles.COMMAND_BLOCK.get(), direction), endPos.m_7096_(), endPos.m_7098_(), endPos.m_7094_(), speed.m_7096_(), speed.m_7098_(), speed.m_7094_());
        }
    }

    public static void spawnHeatedWaterParticles(Level level, BlockPos pos, RandomSource random, boolean isFalling, double height, boolean steamConfig, boolean boilingConfig) {
        int brightness = level.m_45517_(LightLayer.BLOCK, pos);
        height -= 0.1;
        switch (ModConfigs.BLOCKS.steam.spawnLogic) {
            case NEAR_LAVA: {
                for (int x = -1; x < 2; ++x) {
                    for (int y = -1; y < 2; ++y) {
                        for (int z = -1; z < 2; ++z) {
                            if (!level.m_6425_(pos.m_7918_(x, y, z)).m_205070_(FluidTags.f_13132_)) continue;
                            ParticleSpawnUtil.spawnHeatedWaterParticles(level, pos, random, isFalling, height, steamConfig, boilingConfig, brightness);
                        }
                    }
                }
                break;
            }
            case BRIGHTNESS: {
                if (brightness <= (Integer)ModConfigs.BLOCKS.steam.steamingThreshold.get() && !level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50450_)) break;
                ParticleSpawnUtil.spawnHeatedWaterParticles(level, pos, random, isFalling, height, steamConfig, boilingConfig, brightness);
            }
        }
    }

    private static void spawnHeatedWaterParticles(Level level, BlockPos pos, RandomSource random, boolean isFalling, double height, boolean steamConfig, boolean boilingConfig, int brightness) {
        if (steamConfig && !isFalling && !Util.isSolidOrNotEmpty(level, pos.m_7494_())) {
            level.m_7106_((ParticleOptions)ModParticles.STEAM.get(), (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() + 0.875 + MathUtil.nextDouble(random, 0.5), (double)pos.m_123343_() + random.m_188500_(), 0.0, 0.0, 0.0);
        }
        if (boilingConfig && brightness >= (Integer)ModConfigs.BLOCKS.steam.boilingThreshold.get()) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)pos.m_123341_() + random.m_188500_(), Mth.m_14008_((double)random.m_188500_(), (double)pos.m_123342_(), (double)((double)pos.m_123342_() + height)), (double)pos.m_123343_() + random.m_188500_(), 0.0, 0.0, 0.0);
        }
    }

    public static void spawnEntityFellParticles(LivingEntity entity, double y, float distance, int fallDamage, boolean config) {
        if (!config || entity.m_6095_().m_204039_(EntityTypeTags.f_273841_)) {
            return;
        }
        if (entity.m_20145_()) {
            return;
        }
        if (!(fallDamage > 0 || entity instanceof AbstractHorse && (double)distance > (entity instanceof Camel ? 0.5 : 1.0))) {
            return;
        }
        if (entity.m_20069_() || entity.m_20077_() || entity.f_146808_) {
            return;
        }
        Level level = entity.m_9236_();
        RandomSource random = entity.m_217043_();
        if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.m_46758_(entity.m_20183_())) {
            return;
        }
        if (!level.m_6425_(entity.m_20097_().m_175288_(Mth.m_14107_((double)y))).m_76178_()) {
            return;
        }
        if (fallDamage < 4) {
            for (int i = 0; i < 5; ++i) {
                level.m_7106_((ParticleOptions)ModParticles.SMALL_DUST_CLOUD.get(), entity.m_20208_(1.0), y + Math.max(Math.min((double)random.m_188501_(), 0.5), 0.2), entity.m_20262_(1.0), 0.3 * (double)MathUtil.nextSign(random), random.m_188500_(), 0.3 * (double)MathUtil.nextSign(random));
            }
            return;
        }
        for (int i = 0; i < 10; ++i) {
            level.m_7106_((ParticleOptions)ModParticles.LARGE_DUST_CLOUD.get(), entity.m_20208_(1.0), y + Math.max(Math.min((double)random.m_188501_(), 0.5), 0.2), entity.m_20262_(1.0), 0.5 * (double)MathUtil.nextSign(random), random.m_188500_() * 3.0, 0.5 * (double)MathUtil.nextSign(random));
        }
    }

    public static void spawnEntityFaceParticle(ParticleOptions options, LivingEntity entity, Level level, RandomSource random, Vec3 offset, float partialTick) {
        ParticleSpawnUtil.spawnEntityFaceParticle(options, entity, level, random, new Vec3(((double)random.m_188501_() - 0.5) * 0.3, (double)(-random.m_188501_()) * 0.6 - 0.3, 0.6).m_82549_(offset), new Vec3(((double)random.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1 + 0.05, 0.0), partialTick);
    }

    public static void spawnEntityFaceParticle(ParticleOptions options, LivingEntity entity, Level level, RandomSource random, Vec3 offset, Vec3 speed, float partialTick) {
        speed = speed.m_82496_(-entity.m_5686_(partialTick) * ((float)Math.PI / 180));
        speed = speed.m_82524_(-entity.m_5675_(partialTick) * ((float)Math.PI / 180));
        ParticleSpawnUtil.spawnEntityFaceParticle(options, entity, level, offset, speed, partialTick);
    }

    public static void spawnEntityFaceParticle(ParticleOptions options, LivingEntity entity, Level level, Vec3 offset, Vec3 speed, float partialTick) {
        ParticleSpawnUtil.spawnEntityHeadParticle(options, entity, level, offset.m_82520_(0.0, 0.0, 0.6), speed, partialTick);
    }

    public static void spawnEntityHeadParticle(ParticleOptions options, LivingEntity entity, Level level, Vec3 pos, Vec3 speed, float partialTick) {
        pos = pos.m_82496_(-entity.m_5686_(partialTick) * ((float)Math.PI / 180));
        pos = pos.m_82524_(-entity.m_5675_(partialTick) * ((float)Math.PI / 180));
        pos = pos.m_82520_(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        level.m_7106_(options, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), speed.m_7096_(), speed.m_7098_(), speed.m_7094_());
    }

    public static void spawnEnderEyePlacementParticles(BlockPos pos, RandomSource random, ClientLevel level, int color) {
        if (ModConfigs.BLOCKS.enderEyePlacedRings) {
            level.m_7106_((ParticleOptions)new ColorParticleOptions(ModParticles.ENDER_EYE_PLACED_RING.get(), Vec3.m_82501_((int)color).m_252839_()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.8125 + (double)0.2501f, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
        if (ModConfigs.BLOCKS.enderEyePlacedParticlesDisplayType != ModBlockConfigs.EnderEyePlacedParticlesDisplayType.VANILLA) {
            for (int i = 0; i < 16; ++i) {
                level.m_7106_((ParticleOptions)new ColorParticleOptions(ModParticles.SHORT_SPARK.get(), Vec3.m_82501_((int)color).m_252839_()), (double)pos.m_123341_() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.25), (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.25), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawnParticlesAroundShape(ParticleOptions particle, Level level, BlockPos pos, BlockState state, int count, Supplier<Vec3> particleSpeed, float offset) {
        DoubleBlockHalf half;
        BlockPos oppositePos;
        BlockState oppositeState;
        if (state.m_61138_((Property)BlockStateProperties.f_61401_) && (oppositeState = level.m_8055_(oppositePos = pos.m_121945_((half = (DoubleBlockHalf)state.m_61143_((Property)BlockStateProperties.f_61401_)) == DoubleBlockHalf.UPPER ? Direction.UP : Direction.DOWN))).m_60713_(state.m_60734_()) && oppositeState.m_61138_((Property)BlockStateProperties.f_61401_)) {
            DoubleBlockHalf otherHalf;
            DoubleBlockHalf doubleBlockHalf = otherHalf = half == DoubleBlockHalf.UPPER ? DoubleBlockHalf.LOWER : DoubleBlockHalf.UPPER;
            if (otherHalf.equals((Object)oppositeState.m_61143_((Property)BlockStateProperties.f_61401_))) {
                ParticleSpawnUtil.spawnParticlesAroundShape(particle, level, oppositePos, state, direction -> half == DoubleBlockHalf.LOWER && direction == Direction.UP || half == DoubleBlockHalf.UPPER && direction == Direction.DOWN, count, particleSpeed, offset);
            }
        }
        ParticleSpawnUtil.spawnParticlesAroundShape(particle, level, pos, state, null, count, particleSpeed, offset);
    }

    public static void spawnParticlesAroundShape(ParticleOptions particle, Level level, BlockPos pos, BlockState state, @Nullable Predicate<Direction> predicate, int count, Supplier<Vec3> particleSpeed, float offset) {
        RandomSource random = level.m_213780_();
        state.m_60808_((BlockGetter)level, pos).m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            for (Direction direction : Direction.values()) {
                BlockPos relativePos;
                if (predicate != null && predicate.test(direction) || level.m_8055_(relativePos = pos.m_121945_(direction)).m_60804_((BlockGetter)level, relativePos)) continue;
                Direction.Axis axis = direction.m_122434_();
                Direction.AxisDirection axisDirection = direction.m_122421_();
                boolean isPositive = axisDirection == Direction.AxisDirection.POSITIVE;
                for (int i = 0; i < count; ++i) {
                    double yOffset;
                    double xOffset;
                    double d = axis == Direction.Axis.X ? (isPositive ? maxX : minX) : (xOffset = Mth.m_216263_((RandomSource)random, (double)minX, (double)maxX));
                    double d2 = axis == Direction.Axis.Y ? (isPositive ? maxY : minY) : (yOffset = Mth.m_216263_((RandomSource)random, (double)minY, (double)maxY));
                    double zOffset = axis == Direction.Axis.Z ? (isPositive ? maxZ : minZ) : Mth.m_216263_((RandomSource)random, (double)minZ, (double)maxZ);
                    Vec3 speed = (Vec3)particleSpeed.get();
                    level.m_7106_(particle, (double)pos.m_123341_() + xOffset + (double)(offset * (float)axisDirection.m_122540_()), (double)pos.m_123342_() + yOffset + (double)(offset * (float)axisDirection.m_122540_()), (double)pos.m_123343_() + zOffset + (double)(offset * (float)axisDirection.m_122540_()), speed.m_7096_(), speed.m_7098_(), speed.m_7094_());
                }
            }
        });
    }

    public static void spawnHammeringWorkstationParticles(BlockPos pos, RandomSource random, ClientLevel level) {
        float pointX = random.m_188501_();
        float pointZ = random.m_188501_();
        for (int i2 = 0; i2 < 20; ++i2) {
            int xSign = MathUtil.nextSign(random);
            int zSign = MathUtil.nextSign(random);
            level.m_7106_((ParticleOptions)SparkParticle.create(SparkType.METAL, random), (double)((float)pos.m_123341_() + pointX), (double)(pos.m_123342_() + 1), (double)((float)pos.m_123343_() + pointZ), (double)(Mth.m_216267_((RandomSource)random, (float)0.1f, (float)0.2f) * (float)xSign), (double)Mth.m_216267_((RandomSource)random, (float)0.1f, (float)0.2f), (double)(Mth.m_216267_((RandomSource)random, (float)0.1f, (float)0.2f) * (float)zSign));
        }
    }

    public static void spawnCompostParticles(Level level, BlockPos pos, ParticleOptions particle, double xSpeed, double ySpeed, double zSpeed) {
        RandomSource random = level.m_213780_();
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof ComposterBlock) {
            for (int i = 0; i < 10; ++i) {
                level.m_7106_(particle, (double)pos.m_123341_() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.3), (double)pos.m_123342_() + 0.1875 + 0.125 * (double)((Integer)state.m_61143_((Property)ComposterBlock.f_51913_)).intValue(), (double)pos.m_123343_() + 0.5 + MathUtil.nextNonAbsDouble(random, 0.3), xSpeed, ySpeed, zSpeed);
            }
        }
    }
}

