/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.particle.option.IntegerParticleOptions;
import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FlameGeyserTicker
extends Ticker {
    public static final List<BlockPos> ACTIVE_GEYSERS = new ArrayList<BlockPos>();
    public static final List<BlockPos> INACTIVE_GEYSERS = new ArrayList<BlockPos>();
    public static final List<Block> VALID_BLOCKS = List.of(Blocks.f_50134_, Blocks.f_50730_, Blocks.f_50136_);
    private final ParticleOptions particle;
    private final Level level;
    private final BlockPos pos;
    private final RandomSource random;
    private final int lifeTime;
    private int age;

    public FlameGeyserTicker(Level level, BlockPos pos, RandomSource random) {
        this.level = level;
        this.pos = pos;
        this.random = random;
        this.particle = level.m_204166_(pos).m_203565_(Biomes.f_48199_) ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_;
        this.lifeTime = this.getTickDelay((Integer)ModConfigs.ENVIRONMENT.flameGeyserActiveTime.get());
        ACTIVE_GEYSERS.add(pos);
    }

    @Override
    public void tick() {
        ++this.age;
        if (this.age >= this.lifeTime) {
            this.remove();
            return;
        }
        if (Util.isChunkLoaded(this.level, this.pos.m_123341_(), this.pos.m_123343_()) && FlameGeyserTicker.checkLocation(this.level, this.pos, false)) {
            if (this.age == 1) {
                this.level.m_7106_((ParticleOptions)new IntegerParticleOptions(ModParticles.GEYSER_HOLE.get(), this.lifeTime), (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.001, (double)this.pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            }
            if (this.age % 5 == 0) {
                Util.playClientSound(this.pos, ModSounds.GEYSER_WHOOSH.get(), SoundSource.BLOCKS, ((Float)ModConfigs.ENVIRONMENT.flameGeyserSoundVolume.get()).floatValue(), this.random.m_188501_() * 0.7f + 0.3f);
            }
            for (int i = 0; i < 10; ++i) {
                this.level.m_7106_(this.particle, (double)this.pos.m_123341_() + 0.5 + MathUtil.nextNonAbsDouble(this.random, 0.1), (double)this.pos.m_123342_() + 1.0625, (double)this.pos.m_123343_() + 0.5 + MathUtil.nextNonAbsDouble(this.random, 0.1), MathUtil.nextNonAbsDouble(this.random, 0.01, 0.05), Mth.m_216263_((RandomSource)this.random, (double)0.3, (double)0.35), MathUtil.nextNonAbsDouble(this.random, 0.01, 0.05));
            }
            return;
        }
        this.remove();
    }

    public static boolean checkLocation(Level level, BlockPos pos, boolean checkAbove) {
        BlockPos abovePos;
        if (VALID_BLOCKS.contains(level.m_8055_(pos).m_60734_()) && FlameGeyserTicker.isNotFaceSturdyOrFluidEmpty(level, abovePos = pos.m_7494_())) {
            if (checkAbove) {
                for (int i = 1; i < 5; ++i) {
                    if (FlameGeyserTicker.isNotFaceSturdyOrFluidEmpty(level, abovePos.m_5484_(Direction.UP, i))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isNotFaceSturdyOrFluidEmpty(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return !state.m_60783_((BlockGetter)level, pos, Direction.DOWN) && !(state.m_60734_() instanceof BaseFireBlock) && level.m_6425_(pos).m_76178_();
    }

    @Override
    public void remove() {
        super.remove();
        ACTIVE_GEYSERS.remove(this.pos);
        INACTIVE_GEYSERS.add(this.pos);
        TickerManager.schedule(this.getTickDelay((Integer)ModConfigs.ENVIRONMENT.flameGeyserInactiveTime.get()), () -> INACTIVE_GEYSERS.remove(this.pos));
    }

    private int getTickDelay(int max) {
        return max >= 300 ? Mth.m_216271_((RandomSource)this.random, (int)(max - 200), (int)max) : max;
    }
}

