/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.configs.ModBlockConfigs;
import einstein.subtle_effects.configs.ReplacedParticlesDisplayType;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.tickers.TickerManager;
import einstein.subtle_effects.util.FrustumGetter;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleAccessor;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin
implements FrustumGetter {
    @Shadow
    @Nullable
    private ClientLevel f_109465_;
    @Shadow
    private Frustum f_172938_;
    @Shadow
    @Final
    private Minecraft f_109461_;

    @WrapOperation(method={"renderSnowAndRain"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;RAIN_LOCATION:Lnet/minecraft/resources/ResourceLocation;")})
    private ResourceLocation replaceRainTexture(Operation<ResourceLocation> original) {
        if (ModConfigs.ENVIRONMENT.biomeColorRain) {
            return Util.COLORLESS_RAIN_TEXTURE;
        }
        return (ResourceLocation)original.call(new Object[0]);
    }

    @WrapOperation(method={"renderSnowAndRain"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/VertexConsumer;color(FFFF)Lcom/mojang/blaze3d/vertex/VertexConsumer;")})
    private VertexConsumer renderSnowAndRain(VertexConsumer instance, float red, float green, float blue, float alpha, Operation<VertexConsumer> original, @Local Biome biome, @Local Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.RAIN && ModConfigs.ENVIRONMENT.biomeColorRain) {
            int waterColor = biome.m_47560_();
            return instance.m_85950_((float)(waterColor >> 16) / 255.0f, (float)(waterColor >> 8) / 255.0f, (float)waterColor / 255.0f, alpha);
        }
        return (VertexConsumer)original.call(new Object[]{instance, Float.valueOf(red), Float.valueOf(green), Float.valueOf(blue), Float.valueOf(alpha)});
    }

    @Inject(method={"levelEvent"}, at={@At(value="TAIL")})
    private void levelEvent(int type, BlockPos pos, int data, CallbackInfo ci) {
        if (this.f_109465_ == null) {
            return;
        }
        RandomSource random = this.f_109465_.m_213780_();
        BlockState state = this.f_109465_.m_8055_(pos);
        LocalPlayer player = this.f_109461_.f_91074_;
        switch (type) {
            case 1029: {
                if (!ModConfigs.BLOCKS.anvilBreakParticles) break;
                this.f_109465_.m_142052_(pos, state);
                break;
            }
            case 1030: {
                if (!ModConfigs.BLOCKS.anvilUseParticles) break;
                for (int i = 0; i < 3; ++i) {
                    TickerManager.schedule(8 * i, () -> ParticleSpawnUtil.spawnHammeringWorkstationParticles(pos, random, this.f_109465_));
                }
                break;
            }
            case 1042: {
                if (!ModConfigs.BLOCKS.grindstoneUseParticles || !state.m_61138_((Property)GrindstoneBlock.f_54117_) || !state.m_61138_((Property)GrindstoneBlock.f_53179_)) break;
                Direction direction = (Direction)state.m_61143_((Property)GrindstoneBlock.f_54117_);
                AttachFace face = (AttachFace)state.m_61143_((Property)GrindstoneBlock.f_53179_);
                Direction side = face == AttachFace.CEILING ? Direction.DOWN : Direction.UP;
                for (int i = 0; i < 20; ++i) {
                    ParticleSpawnUtil.spawnParticlesOnSide((ParticleOptions)SparkParticle.create(SparkType.METAL, random), 0.0f, side, (Level)this.f_109465_, pos, random, (double)Mth.m_216267_((RandomSource)random, (float)0.1f, (float)0.2f) * ((double)direction.m_122429_() * 1.5), face == AttachFace.CEILING ? 0.0 : (double)Mth.m_216267_((RandomSource)random, (float)0.1f, (float)0.2f), (double)Mth.m_216267_((RandomSource)random, (float)0.1f, (float)0.2f) * ((double)direction.m_122431_() * 1.5));
                }
                break;
            }
            case 1044: {
                if (!ModConfigs.BLOCKS.smithingTableUseParticles) break;
                ParticleSpawnUtil.spawnHammeringWorkstationParticles(pos, random, this.f_109465_);
                break;
            }
            case 1503: {
                TickerManager.scheduleNext(() -> ParticleSpawnUtil.spawnEnderEyePlacementParticles(pos, random, this.f_109465_, Util.getEyeColorHolder((Level)this.f_109465_, pos).toInt()));
            }
        }
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/ParticleUtils;spawnParticlesOnBlockFaces(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/util/valueproviders/IntProvider;)V")})
    private void cancelOrReplaceCopperParticles(Level level, BlockPos pos, ParticleOptions particle, IntProvider count, Operation<Void> original, @Local(argsOnly=true, ordinal=0) int type) {
        BlockState state = level.m_8055_(pos);
        RandomSource random = level.m_213780_();
        if (type == 3005) {
            if (ModConfigs.ITEMS.axeScrapeParticlesDisplayType != ReplacedParticlesDisplayType.DEFAULT) {
                LevelRendererMixin.subtleEffects$spawnCopperParticles(level, pos, count, state, random);
            }
            return;
        }
        if (type == 3004) {
            if (ModConfigs.ITEMS.axeWaxOffParticlesDisplayType != ReplacedParticlesDisplayType.DEFAULT) {
                LevelRendererMixin.subtleEffects$spawnCopperParticles(level, pos, count, state, random);
            }
            return;
        }
        original.call(new Object[]{level, pos, particle, count});
    }

    @Unique
    private static void subtleEffects$spawnCopperParticles(Level level, BlockPos pos, IntProvider count, BlockState state, RandomSource random) {
        ParticleSpawnUtil.spawnParticlesAroundShape((ParticleOptions)ParticleTypes.f_175829_, level, pos, state, count.m_214085_(random), () -> new Vec3(MathUtil.nextNonAbsDouble(random, 0.5), MathUtil.nextNonAbsDouble(random, 0.5), MathUtil.nextNonAbsDouble(random, 0.5)), 0.125f);
    }

    @WrapWithCondition(method={"levelEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    private boolean shouldSpawnEndPortalFrameSmoke(ClientLevel level, ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Local(argsOnly=true, ordinal=0) int type) {
        if (type == 1503) {
            return ModConfigs.BLOCKS.enderEyePlacedParticlesDisplayType != ModBlockConfigs.EnderEyePlacedParticlesDisplayType.DOTS;
        }
        return true;
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;LARGE_SMOKE:Lnet/minecraft/core/particles/SimpleParticleType;")})
    private SimpleParticleType replaceSmoke(Operation<SimpleParticleType> original) {
        if (ModConfigs.BLOCKS.steam.lavaFizzSteam) {
            return ModParticles.STEAM.get();
        }
        return (SimpleParticleType)original.call(new Object[0]);
    }

    @WrapOperation(method={"levelEvent"}, at={@At(value="FIELD", target="Lnet/minecraft/core/particles/ParticleTypes;CLOUD:Lnet/minecraft/core/particles/SimpleParticleType;")})
    private SimpleParticleType replaceCloud(Operation<SimpleParticleType> original) {
        if (ModConfigs.BLOCKS.steam.spongeDryingOutSteam) {
            return ModParticles.STEAM.get();
        }
        return (SimpleParticleType)original.call(new Object[0]);
    }

    @ModifyReturnValue(method={"addParticleInternal(Lnet/minecraft/core/particles/ParticleOptions;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="RETURN", ordinal=0)})
    private Particle spawnForcedParticle(Particle particle) {
        if (particle != null) {
            ((ParticleAccessor)particle).subtleEffects$force();
        }
        return particle;
    }

    @Override
    public Frustum subtleEffects$getCullingFrustum() {
        return this.f_172938_;
    }
}

