/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client;

import einstein.subtle_effects.configs.blocks.SparksConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.LavaFluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LavaFluid.class})
public abstract class LavaFluidMixin {
    @Shadow
    public abstract boolean m_6212_(Fluid var1);

    @Inject(method={"animateTick"}, at={@At(value="TAIL")})
    private void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random, CallbackInfo ci) {
        SparksConfigs.LavaSparksSpawnType type = ModConfigs.BLOCKS.sparks.lavaSparks;
        if (type.equals((Object)SparksConfigs.LavaSparksSpawnType.OFF) || type.equals((Object)SparksConfigs.LavaSparksSpawnType.NOT_NETHER) && level.m_46472_().equals((Object)Level.f_46429_)) {
            return;
        }
        if (state.m_61138_((Property)LavaFluid.f_75947_) && ((Boolean)state.m_61143_((Property)LavaFluid.f_75947_)).booleanValue()) {
            for (Direction direction : Direction.values()) {
                BlockPos relativePos = pos.m_121945_(direction);
                if (direction.m_122434_() == Direction.Axis.Y || Util.isSolidOrNotEmpty(level, relativePos)) continue;
                ParticleSpawnUtil.spawnParticlesOnSide((ParticleOptions)SparkParticle.create(SparkType.FLOATING, random), -0.0625f, direction.m_122424_(), level, relativePos, random, MathUtil.nextNonAbsDouble(random, 0.1), MathUtil.nextNonAbsDouble(random, 0.07), MathUtil.nextNonAbsDouble(random, 0.1));
            }
            return;
        }
        int count = 1;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockPos relativePos = pos.m_7918_(x, 0, z);
                if (!this.m_6212_(level.m_6425_(relativePos).m_76152_()) || level.m_8055_(relativePos).m_60804_((BlockGetter)level, relativePos)) {
                    count = 5;
                    continue;
                }
                BlockPos abovePos = relativePos.m_7494_();
                if (!Util.isSolidOrNotEmpty(level, abovePos)) continue;
                if (abovePos.equals((Object)pos.m_7494_())) {
                    return;
                }
                count = 5;
            }
        }
        for (int i = 0; i < count; ++i) {
            level.m_7106_((ParticleOptions)SparkParticle.create(SparkType.FLOATING, random), (double)pos.m_123341_() + 0.5 + random.m_188500_() / 2.0 * (double)MathUtil.nextSign(random), (double)pos.m_123342_() + 0.75 + random.m_188500_() * (double)random.m_188503_(3), (double)pos.m_123343_() + 0.5 + random.m_188500_() / 2.0 * (double)MathUtil.nextSign(random), MathUtil.nextNonAbsDouble(random, 0.1), MathUtil.nextDouble(random, 0.07), MathUtil.nextNonAbsDouble(random, 0.1));
        }
    }
}

