/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client;

import einstein.subtle_effects.data.SparkProviderData;
import einstein.subtle_effects.data.SparkProviderReloadListener;
import einstein.subtle_effects.init.ModBlockTickers;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.tickers.entity_tickers.EntityTickerManager;
import einstein.subtle_effects.util.BlockTickerProvider;
import einstein.subtle_effects.util.Box;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public abstract class ClientLevelMixin
extends Level {
    protected ClientLevelMixin(WritableLevelData levelData, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionType, Supplier<ProfilerFiller> profiler, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionType, profiler, isClientSide, isDebug, biomeZoomSeed, maxNeighborUpdates);
    }

    @Inject(method={"tickNonPassenger"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;tick()V")})
    private void entityTick(Entity entity, CallbackInfo ci) {
        EntityTickerManager.createTickersForEntity(entity);
    }

    @Inject(method={"tickPassenger"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;rideTick()V")})
    private void entityRideTick(Entity vehicleEntity, Entity entity, CallbackInfo ci) {
        EntityTickerManager.createTickersForEntity(entity);
    }

    @Inject(method={"doAnimateTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;animateTick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V")})
    private void animateTick(int x, int y, int z, int range, RandomSource random, Block markerBlock, BlockPos.MutableBlockPos pos, CallbackInfo ci) {
        BlockState state = this.m_8055_((BlockPos)pos);
        Block block = state.m_60734_();
        if (!state.m_60795_()) {
            BlockPos immutablePos = pos.m_7949_();
            BlockTickerProvider tickerProvider = ModBlockTickers.REGISTERED.get(block);
            if (tickerProvider != null) {
                tickerProvider.apply(state, this, immutablePos, random);
            }
            ModBlockTickers.REGISTERED_SPECIAL.forEach((predicate, provider) -> {
                if (predicate.test(state)) {
                    provider.apply(state, this, immutablePos, random);
                }
            });
            List<SparkProviderReloadListener.SparkProvider> providers = SparkProviderReloadListener.PROVIDERS.get(block);
            if (providers != null && !providers.isEmpty()) {
                providers.forEach(provider -> {
                    SparkProviderReloadListener.BlockStateHolder stateHolder = provider.stateHolder();
                    if (!stateHolder.matches(state)) {
                        return;
                    }
                    SparkProviderData.Options options = provider.options();
                    SparkProviderData.PresetType preset = options.preset();
                    List<Integer> colors = options.colors().orElse(SparkParticle.DEFAULT_COLORS);
                    switch (preset) {
                        case CAMPFIRE: {
                            if (!ModConfigs.BLOCKS.sparks.campfireSparks) break;
                            ParticleSpawnUtil.spawnSparks(this, random, (BlockPos)pos, SparkType.LONG_LIFE, new Box(0.3, 0.4, 0.3, 0.6, 0.4, 0.6), new Vec3(0.03, 0.05, 0.03), 10, colors);
                            break;
                        }
                        case TORCH: {
                            if (!ModConfigs.BLOCKS.sparks.torchSparks) break;
                            ParticleSpawnUtil.spawnSparks(this, random, (BlockPos)pos, SparkType.SHORT_LIFE, new Box(0.3, 0.5, 0.3, 0.6, 0.5, 0.6), new Vec3(0.01, 0.01, 0.01), 2, colors);
                            break;
                        }
                        case WALL_TORCH: {
                            if (!ModConfigs.BLOCKS.sparks.torchSparks || !state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                                return;
                            }
                            Direction direction = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_();
                            Vec3 offset2 = new Vec3(0.5 + 0.27 * (double)direction.m_122429_(), 0.7, 0.5 + 0.27 * (double)direction.m_122431_());
                            ParticleSpawnUtil.spawnSparks(this, random, (BlockPos)pos, SparkType.SHORT_LIFE, new Box(offset2.m_82492_(0.05, 0.0, 0.05), offset2.m_82520_(0.05, 0.0, 0.05)), new Vec3(0.01, 0.01, 0.01), 2, colors);
                            break;
                        }
                        case CANDLE: {
                            if (!ModConfigs.BLOCKS.sparks.candleSparks || !(block instanceof AbstractCandleBlock)) break;
                            AbstractCandleBlock candleBlock = (AbstractCandleBlock)block;
                            candleBlock.m_142199_(state).forEach(offset -> ParticleSpawnUtil.spawnSparks(this, random, (BlockPos)pos, SparkType.SHORT_LIFE, new Box(offset.m_82492_(0.05, 0.0, 0.05), offset.m_82520_(0.05, 0.0, 0.05)), new Vec3(0.01, 0.01, 0.01), 2, colors));
                            break;
                        }
                        case LANTERN: {
                            for (int i = 0; i < (Integer)ModConfigs.BLOCKS.sparks.lanternSparksDensity.get(); ++i) {
                                int xSign = MathUtil.nextSign(random);
                                int zSign = MathUtil.nextSign(random);
                                this.m_7106_((ParticleOptions)SparkParticle.create(SparkType.FLOATING, random, colors), (double)pos.m_123341_() + 0.5 + MathUtil.nextDouble(random, 0.5) * (double)xSign, (double)pos.m_123342_() + (double)random.m_188503_(5) / 10.0, (double)pos.m_123343_() + 0.5 + MathUtil.nextDouble(random, 0.5) * (double)zSign, MathUtil.nextDouble(random, 0.03) * (double)xSign, 0.0, MathUtil.nextDouble(random, 0.03) * (double)zSign);
                            }
                            break;
                        }
                        case FIRE: {
                            if (!ModConfigs.BLOCKS.sparks.fireSparks || !(block instanceof BaseFireBlock)) break;
                            BaseFireBlock fireBlock = (BaseFireBlock)block;
                            BlockPos belowPos = pos.m_7495_();
                            BlockState belowState = this.m_8055_(belowPos);
                            if (!fireBlock.m_7599_(belowState) && !belowState.m_60783_((BlockGetter)this, belowPos, Direction.UP)) {
                                for (Direction direction : Direction.Plane.HORIZONTAL) {
                                    if (!fireBlock.m_7599_(this.m_8055_(pos.m_121945_(direction)))) continue;
                                    Direction.Axis axis = direction.m_122434_();
                                    boolean i = direction.m_122421_() != Direction.AxisDirection.NEGATIVE;
                                    ClientLevelMixin.subtleEffects$spawnFireSparks(this, random, (BlockPos)pos, colors, axis == Direction.Axis.X ? (double)i : random.m_188500_(), axis == Direction.Axis.Z ? random.m_188500_() : (double)i);
                                }
                                return;
                            }
                            ClientLevelMixin.subtleEffects$spawnFireSparks(this, random, (BlockPos)pos, colors, random.m_188500_(), random.m_188500_());
                            break;
                        }
                        case FURNACE: {
                            if (!ModConfigs.BLOCKS.sparks.furnaceSparks || !state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                                return;
                            }
                            Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                            Direction.Axis axis = direction.m_122434_();
                            for (int i = 0; i < 3; ++i) {
                                this.m_7106_((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, random, colors), (double)pos.m_123341_() + 0.5 + 0.6 * (double)direction.m_122429_() + random.m_188500_() / (double)(axis == Direction.Axis.X ? 10 : 3) * (double)MathUtil.nextSign(random), (double)pos.m_123342_() + random.m_188500_() * 6.0 / 16.0, (double)pos.m_123343_() + 0.5 + 0.6 * (double)direction.m_122431_() + random.m_188500_() / (double)(axis == Direction.Axis.Z ? 10 : 3) * (double)MathUtil.nextSign(random), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01));
                            }
                            break;
                        }
                        case CUSTOM: {
                            Box box = options.box().orElse(new Box());
                            SparkType sparkType = options.sparkType().orElse(SparkType.SHORT_LIFE);
                            Vec3 velocity = options.velocity().orElse(new Vec3(0.03, 0.05, 0.03));
                            IntProvider count = options.count().orElse((IntProvider)ConstantInt.m_146483_((int)10));
                            float chance = options.chance().orElse(Float.valueOf(1.0f)).floatValue();
                            if (!(random.m_188501_() <= chance)) break;
                            ParticleSpawnUtil.spawnSparks(this, random, (BlockPos)pos, sparkType, box, velocity, count.m_214085_(random), colors);
                        }
                    }
                });
            }
        }
    }

    @Unique
    private static void subtleEffects$spawnFireSparks(Level level, RandomSource random, BlockPos pos, List<Integer> colors, double xOffset, double zOffset) {
        for (int i = 0; i < 5; ++i) {
            level.m_7106_((ParticleOptions)SparkParticle.create(SparkType.LONG_LIFE, random, colors), (double)pos.m_123341_() + xOffset + random.m_188500_() / 10.0 * (double)MathUtil.nextSign(random), (double)pos.m_123342_() + random.m_188500_(), (double)pos.m_123343_() + zOffset + random.m_188500_() / 10.0 * (double)MathUtil.nextSign(random), MathUtil.nextNonAbsDouble(random, 0.03), MathUtil.nextNonAbsDouble(random, 0.05), MathUtil.nextNonAbsDouble(random, 0.03));
        }
    }
}

