/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.configs.environment;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import me.fzzyhmstrs.fzzy_config.config.ConfigSection;
import me.fzzyhmstrs.fzzy_config.entry.Entry;
import me.fzzyhmstrs.fzzy_config.util.AllowableIdentifiers;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedList;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

@Translation(prefix="config.subtle_effects.environment.biomes")
public class BiomeConfigs
extends ConfigSection {
    public ValidatedInt biomeParticlesRadius = new ValidatedInt(32, 32, 0);
    public ValidatedList<ResourceLocation> mushroomSporeBiomes = BiomeConfigs.biomeList("mushroom_fields");
    public ValidatedInt mushroomSporeDensity = new ValidatedInt(10, 100, 0);
    public ValidatedList<ResourceLocation> fireflyBiomes = BiomeConfigs.biomeList("swamp", "mangrove_swamp");
    public ValidatedInt fireflyDensity = new ValidatedInt(6, 100, 0);
    public ValidatedList<ResourceLocation> pollenBiomes = BiomeConfigs.biomeList("flower_forest", "sunflower_plains");
    public ValidatedInt pollenDensity = new ValidatedInt(50, 100, 0);
    public ValidatedList<ResourceLocation> sculkDustBiomes = BiomeConfigs.biomeList("deep_dark");
    public ValidatedInt sculkDustDensity = new ValidatedInt(5, 100, 0);

    public static ValidatedList<ResourceLocation> biomeList(String ... biomeIds) {
        return new ValidatedList(Arrays.stream(biomeIds).map(ResourceLocation::new).toList(), (Entry)new ValidatedIdentifier(new ResourceLocation("air"), new AllowableIdentifiers(location -> BiomeConfigs.getBiomeRegistry().map(biomes -> biomes.m_7804_(location)).orElse(true), () -> BiomeConfigs.getBiomeRegistry().map(biomes -> biomes.m_6566_().stream().toList()).orElseGet(List::of))));
    }

    private static Optional<Registry<Biome>> getBiomeRegistry() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            return level.m_9598_().m_6632_(Registries.f_256952_);
        }
        return Optional.empty();
    }
}

