/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import einstein.subtle_effects.SubtleEffects;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class EinsteinSolarSystemModel
extends Model {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(SubtleEffects.loc("einstein_solar_system"), "main");
    private static final Vector3f[] HEAD_ROTATIONS = new Vector3f[]{new Vector3f(27.6f, 61.0f, -9.7f), new Vector3f(2.5f, 8.6f, -13.8f), new Vector3f(-64.7f, 48.2f, -41.9f)};
    private final ModelPart head;
    private final ModelPart hat;

    public EinsteinSolarSystemModel(ModelPart rootPart) {
        super(RenderType::m_110452_);
        this.head = rootPart.m_171324_("head");
        this.hat = rootPart.m_171324_("hat");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        partDefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void render(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, float partialTicks, AbstractClientPlayer player) {
        int headCount = HEAD_ROTATIONS.length;
        for (int i = 0; i < headCount; ++i) {
            float i1 = i + 1;
            float spin = EinsteinSolarSystemModel.getSpin(partialTicks, player, i) * ((float)headCount / i1);
            Vector3f rotation = HEAD_ROTATIONS[i];
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-180.0f - Mth.m_14189_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_)));
            poseStack.m_252781_(Axis.f_252436_.m_252961_(spin));
            poseStack.m_85837_(0.7 * (double)i1, player.m_6047_() ? 0.0 : -0.25, 0.0);
            poseStack.m_85841_(0.8f, 0.8f, 0.8f);
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252529_.m_252977_(rotation.x()));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation.y()));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation.z()));
            poseStack.m_252781_(Axis.f_252436_.m_252961_(spin));
            this.head.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            this.hat.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }

    public static float getSpin(float partialTicks, AbstractClientPlayer player, float speed) {
        return ((float)player.f_19797_ + partialTicks) / 20.0f + (float)Math.PI * speed;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, float f, float f1, float f2, float f3) {
    }
}

