/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.client.gui;

import immersive_melodies.Common;
import immersive_melodies.Config;
import immersive_melodies.client.gui.ImmersiveMelodiesFreePlayingScreen;
import immersive_melodies.client.gui.widget.MelodyListWidget;
import immersive_melodies.client.gui.widget.TexturedButtonWidget;
import immersive_melodies.cobalt.network.NetworkHandler;
import immersive_melodies.item.InstrumentItem;
import immersive_melodies.network.PacketSplitter;
import immersive_melodies.network.c2s.ItemActionMessage;
import immersive_melodies.network.c2s.MelodyDeleteRequest;
import immersive_melodies.network.c2s.TrackToggleMessage;
import immersive_melodies.resources.ClientMelodyManager;
import immersive_melodies.resources.Melody;
import immersive_melodies.resources.MelodyDescriptor;
import immersive_melodies.resources.Track;
import immersive_melodies.util.MidiConverter;
import immersive_melodies.util.MidiParser;
import immersive_melodies.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ImmersiveMelodiesScreen
extends Screen {
    public static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("immersive_melodies:textures/gui/paper.png");
    private MelodyListWidget list;
    private MelodyListWidget trackList;
    private EditBox search;
    private Component error;
    private long lastError;
    private boolean showTrackSelection;
    private Set<Integer> enabledTracks;
    private ResourceLocation selected;

    private void setError(Component error) {
        this.error = error;
        this.lastError = System.currentTimeMillis();
        this.search.m_94144_("");
        this.search.m_94167_(null);
    }

    public ImmersiveMelodiesScreen() {
        super((Component)Component.m_237115_((String)"itemGroup.immersive_melodies.immersive_melodies_tab"));
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        ItemStack stack;
        Item item;
        this.search = new EditBox(this.f_96547_, this.f_96543_ / 2 - 70, this.f_96544_ / 2 - 103, 140, 20, (Component)Component.m_237115_((String)"immersive_melodies.search"));
        this.search.m_94199_(128);
        this.search.m_94151_(a -> {
            this.refreshPage();
            this.search.m_94167_(null);
            this.list.m_93410_(0.0);
        });
        this.search.m_94182_(false);
        this.search.m_94202_(0x808080);
        this.search.m_94167_("Search");
        this.m_264313_((GuiEventListener)this.search);
        int y = (this.f_96544_ - 230) / 2 + 22;
        this.list = new MelodyListWidget(this.f_96541_, this, this.f_96543_ / 2 - 75, 150, y, 162, true);
        this.trackList = new MelodyListWidget(this.f_96541_, this, this.f_96543_ / 2 + 100, 85, y + 8, 142, false);
        this.refreshPage();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null && (item = (stack = this.f_96541_.f_91074_.m_21120_(InteractionHand.MAIN_HAND)).m_41720_()) instanceof InstrumentItem) {
            InstrumentItem item2 = (InstrumentItem)item;
            this.selected = item2.getMelody(stack);
        }
    }

    private void updateTrackList() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            ItemStack stack = this.f_96541_.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
            Item item = stack.m_41720_();
            if (item instanceof InstrumentItem) {
                InstrumentItem item2 = (InstrumentItem)item;
                Set<Integer> newEnabledTracks = item2.getEnabledTracks(stack);
                if (!Objects.equals(newEnabledTracks, this.enabledTracks)) {
                    this.enabledTracks = new HashSet<Integer>(newEnabledTracks);
                    this.refreshPage();
                }
            } else {
                this.enabledTracks = new HashSet<Integer>();
            }
        }
    }

    private void openHelp() {
        try {
            Util.m_137581_().m_137648_(URI.create("https://github.com/Luke100000/ImmersiveMelodies/wiki/Custom-Melodies"));
        }
        catch (Exception e) {
            Common.LOGGER.error((Object)e);
        }
    }

    public void m_7400_(List<Path> paths) {
        PathMatcher midiMatcher = FileSystems.getDefault().getPathMatcher("glob:*{.mid,.midi,.MID,.MIDI}");
        PathMatcher abcMatcher = FileSystems.getDefault().getPathMatcher("glob:*{.abc,.ABC}");
        for (Path path : paths) {
            try {
                String rawName = path.getFileName().toString();
                String name = rawName.substring(0, rawName.lastIndexOf(46));
                if (midiMatcher.matches(path.getFileName())) {
                    FileInputStream inputStream = new FileInputStream(path.toFile());
                    this.parseMidi(name, inputStream);
                    continue;
                }
                if (abcMatcher.matches(path.getFileName())) {
                    byte[] bytes = Files.readAllBytes(path);
                    Minecraft.m_91087_().execute(() -> {
                        try {
                            MidiConverter.Response request = MidiConverter.request(bytes);
                            ByteArrayInputStream inputStream = new ByteArrayInputStream(request.getBody());
                            this.parseMidi(name, inputStream);
                        }
                        catch (Exception e) {
                            Common.LOGGER.error((Object)e);
                            this.setError((Component)Component.m_237115_((String)"immersive_melodies.error.empty"));
                        }
                    });
                    continue;
                }
                this.setError((Component)Component.m_237115_((String)"immersive_melodies.error.unknown_file_type"));
            }
            catch (Exception e) {
                Common.LOGGER.error((Object)e);
                this.setError((Component)Component.m_237113_((String)e.getLocalizedMessage()));
            }
        }
    }

    private void parseMidi(String name, InputStream inputStream) {
        Melody melody;
        if (name.isEmpty()) {
            name = "empty";
        }
        if (!(melody = MidiParser.parseMidi(inputStream, name)).getTracks().isEmpty()) {
            PacketSplitter.sendToServer(name, melody);
            this.search.m_94144_(name);
            this.list.m_93410_(0.0);
        } else {
            this.setError((Component)Component.m_237115_((String)"immersive_melodies.error.empty"));
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.updateTrackList();
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_280273_(context);
        int x = (this.f_96543_ - 192) / 2;
        int y = (this.f_96544_ - 230) / 2;
        if (this.showTrackSelection) {
            int overlap = 10;
            int trackListWidth = 75;
            context.m_280218_(BACKGROUND_TEXTURE, x + 192 - overlap, y + 8, 0, 0, 32, 100);
            context.m_280218_(BACKGROUND_TEXTURE, x + 192 - overlap, y + 108, 0, 115, 32, 100);
            context.m_280218_(BACKGROUND_TEXTURE, x + 192 - overlap + 32, y + 8, 192 - overlap - trackListWidth, 0, overlap + trackListWidth, 100);
            context.m_280218_(BACKGROUND_TEXTURE, x + 192 - overlap + 32, y + 108, 192 - overlap - trackListWidth, 115, overlap + trackListWidth, 100);
            context.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"immersive_melodies.tracks"), this.f_96543_ / 2 + 100, this.f_96544_ / 2 - 94, 0, false);
        }
        context.m_280218_(BACKGROUND_TEXTURE, x, y, 0, 0, 192, 215);
        if (!Config.getInstance().clickedHelp) {
            context.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"immersive_melodies.read"), this.f_96543_ / 2 + 55, this.f_96544_ / 2 + 69 + 17);
        }
        if (this.error != null && System.currentTimeMillis() - this.lastError < 5000L) {
            context.m_280653_(this.f_96547_, this.error, this.f_96543_ / 2, this.f_96544_ / 2 - 103, 0xFF0000);
        }
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    public void refreshPage() {
        this.m_169413_();
        this.m_142416_((GuiEventListener)this.search);
        this.m_142416_((GuiEventListener)this.list);
        this.list.m_93516_();
        Object lastPath = "";
        for (Map.Entry entry : ClientMelodyManager.getMelodiesList().entrySet().stream().filter(e -> this.search.m_94155_().isEmpty() || ((MelodyDescriptor)e.getValue()).getName().toLowerCase(Locale.ROOT).contains(this.search.m_94155_().toLowerCase(Locale.ROOT))).sorted((a, b) -> {
            int primarySortB;
            int primarySortA = ImmersiveMelodiesScreen.getSortIndex(a);
            if (primarySortA != (primarySortB = ImmersiveMelodiesScreen.getSortIndex(b))) {
                return primarySortB - primarySortA;
            }
            return ((MelodyDescriptor)a.getValue()).getName().compareTo(((MelodyDescriptor)b.getValue()).getName());
        }).toList()) {
            String dir = Utils.removeLastPart(((ResourceLocation)entry.getKey()).m_135815_(), "/");
            String path = ((ResourceLocation)entry.getKey()).m_135827_() + "/" + dir;
            if (!path.equals(lastPath)) {
                this.list.addEntry(new ResourceLocation(path), (Component)Component.m_237113_((String)dir).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY), null);
                lastPath = path;
            }
            this.list.addEntry((ResourceLocation)entry.getKey(), (Component)Component.m_237113_((String)((MelodyDescriptor)entry.getValue()).getName()), () -> {
                NetworkHandler.sendToServer(new ItemActionMessage(ItemActionMessage.State.PLAY, (ResourceLocation)entry.getKey()));
                this.selected = (ResourceLocation)entry.getKey();
                this.refreshPage();
            });
            if (!((ResourceLocation)entry.getKey()).equals((Object)this.selected)) continue;
            this.list.m_6987_((AbstractSelectionList.Entry)((MelodyListWidget.MelodyEntry)((Object)this.list.m_6702_().get(this.list.m_6702_().size() - 1))));
        }
        this.trackList.m_93516_();
        if (this.selected != null && this.showTrackSelection) {
            this.m_142416_((GuiEventListener)this.trackList);
            Melody melody = ClientMelodyManager.getMelody(this.selected);
            if (melody != null) {
                for (int i = 0; i < melody.getTracks().size(); ++i) {
                    Track track = melody.getTracks().get(i);
                    int trackId = i;
                    this.trackList.addEntry(new ResourceLocation(this.selected.m_135815_() + "/" + i), (Component)Component.m_237115_((String)track.getName()).m_130940_(this.enabledTracks.contains(i) ? ChatFormatting.DARK_GRAY : ChatFormatting.STRIKETHROUGH), () -> {
                        boolean enabled = this.enabledTracks.contains(trackId);
                        NetworkHandler.sendToServer(new TrackToggleMessage(this.selected, trackId, !enabled));
                        this.refreshPage();
                    });
                }
            }
        }
        int y = this.f_96544_ / 2 + 69;
        this.m_142416_((GuiEventListener)new TexturedButtonWidget(this.f_96543_ / 2 - 75, y, 16, 16, BACKGROUND_TEXTURE, 240, 0, 256, 256, Component.m_130674_(null), button -> this.m_7379_(), () -> List.of(Component.m_237115_((String)"immersive_melodies.close").m_7532_())));
        this.m_142416_((GuiEventListener)new TexturedButtonWidget(this.f_96543_ / 2 - 55, y, 16, 16, BACKGROUND_TEXTURE, 208, 16, 256, 256, Component.m_130674_(null), button -> {
            this.showTrackSelection = !this.showTrackSelection;
            this.refreshPage();
        }, () -> List.of(Component.m_237115_((String)"immersive_melodies.tracks").m_7532_())));
        this.m_142416_((GuiEventListener)new TexturedButtonWidget(this.f_96543_ / 2 - 33, y, 16, 16, BACKGROUND_TEXTURE, 208, 0, 256, 256, Component.m_130674_(null), button -> {
            if (this.f_96541_ != null) {
                this.f_96541_.m_91152_((Screen)new ImmersiveMelodiesFreePlayingScreen());
            }
        }, () -> List.of(Component.m_237115_((String)"immersive_melodies.keyboard").m_7532_())));
        this.m_142416_((GuiEventListener)new TexturedButtonWidget(this.f_96543_ / 2 - 8, y, 16, 16, BACKGROUND_TEXTURE, 224, 32, 256, 256, Component.m_130674_(null), button -> NetworkHandler.sendToServer(new ItemActionMessage(ItemActionMessage.State.PAUSE)), () -> List.of(Component.m_237115_((String)"immersive_melodies.pause").m_7532_())));
        this.m_142416_((GuiEventListener)new TexturedButtonWidget(this.f_96543_ / 2 + 8, y, 16, 16, BACKGROUND_TEXTURE, 240, 32, 256, 256, Component.m_130674_(null), button -> NetworkHandler.sendToServer(new ItemActionMessage(ItemActionMessage.State.CONTINUE)), () -> List.of(Component.m_237115_((String)"immersive_melodies.play").m_7532_())));
        if (this.selected != null && Utils.canDelete(this.selected, (Player)Minecraft.m_91087_().f_91074_)) {
            this.m_142416_((GuiEventListener)new TexturedButtonWidget(this.f_96543_ / 2 + 30, y, 16, 16, BACKGROUND_TEXTURE, 240, 16, 256, 256, Component.m_130674_(null), button -> {
                NetworkHandler.sendToServer(new MelodyDeleteRequest(this.selected));
                this.selected = null;
            }, () -> List.of(Component.m_237115_((String)"immersive_melodies.delete").m_7532_())));
        }
        this.m_142416_((GuiEventListener)new TexturedButtonWidget(this.f_96543_ / 2 + 50, y, 16, 16, BACKGROUND_TEXTURE, 208, 32, 256, 256, Component.m_130674_(null), button -> {
            this.openHelp();
            if (!Config.getInstance().clickedHelp) {
                Config.getInstance().clickedHelp = true;
                Config.getInstance().save();
            }
        }, () -> List.of(Component.m_237115_((String)"immersive_melodies.help").m_7532_())));
    }

    private static int getSortIndex(Map.Entry<ResourceLocation, MelodyDescriptor> entry) {
        return Utils.ownsMelody(entry.getKey(), (Player)Minecraft.m_91087_().f_91074_) ? 2 : (Utils.isPlayerMelody(entry.getKey()) ? 0 : 1);
    }

    public Font getTextRenderer() {
        return this.f_96547_;
    }
}

