/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.api.IModConfigProvider;
import com.mrcrayfish.configured.api.ModContext;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.platform.Services;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class ClientHandler {
    public static final KeyMapping KEY_OPEN_MOD_LIST = new KeyMapping("key.configured.open_mod_list", -1, "key.categories.configured");
    private static Set<IModConfigProvider> providers;

    public static void init() {
        if (providers == null) {
            providers = new LinkedHashSet<IModConfigProvider>();
            providers.addAll(Services.CONFIG.getProviders());
        }
    }

    public static Set<IModConfigProvider> getProviders() {
        ClientHandler.init();
        return providers;
    }

    public static Map<ConfigType, Set<IModConfig>> createConfigMap(ModContext context) {
        HashMap<ConfigType, Set<IModConfig>> modConfigMap = new HashMap<ConfigType, Set<IModConfig>>();
        Set<IModConfig> configs = providers.stream().flatMap(p -> ClientHandler.streamConfigsFromProvider(context, p)).collect(Collectors.toSet());
        configs.forEach(config -> modConfigMap.computeIfAbsent(config.getType(), type -> new LinkedHashSet()).add(config));
        return modConfigMap;
    }

    private static Stream<IModConfig> streamConfigsFromProvider(ModContext context, IModConfigProvider provider) {
        try {
            return provider.getConfigurationsForMod(context).stream();
        }
        catch (Exception e) {
            Constants.LOG.error("An error occurred when loading configs from provider: {}", (Object)provider.getClass().getName());
            e.printStackTrace();
            return Stream.empty();
        }
    }

    public static void updateAbstractListTexture(AbstractSelectionList<?> list) {
        if (list instanceof IBackgroundTexture) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)((IBackgroundTexture)list).getBackgroundTexture());
        }
    }

    public static void updateScreenTexture(Screen screen) {
        if (screen instanceof IBackgroundTexture) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)((IBackgroundTexture)screen).getBackgroundTexture());
        }
    }
}

