/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.menu;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.item.AlbumItem;
import io.github.mortuusars.exposure.item.AlbumPage;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.menu.AlbumPhotographSlot;
import io.github.mortuusars.exposure.menu.AlbumPlayerInventorySlot;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.server.AlbumSignC2SP;
import io.github.mortuusars.exposure.util.ItemAndStack;
import io.github.mortuusars.exposure.util.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlbumMenu
extends AbstractContainerMenu {
    public static final int CANCEL_ADDING_PHOTO_BUTTON = -1;
    public static final int PREVIOUS_PAGE_BUTTON = 0;
    public static final int NEXT_PAGE_BUTTON = 1;
    public static final int LEFT_PAGE_PHOTO_BUTTON = 2;
    public static final int RIGHT_PAGE_PHOTO_BUTTON = 3;
    public static final int ENTER_SIGN_MODE_BUTTON = 4;
    public static final int SIGN_BUTTON = 5;
    public static final int CANCEL_SIGNING_BUTTON = 6;
    protected final ItemAndStack<AlbumItem> album;
    protected final boolean editable;
    protected final List<AlbumPage> pages;
    protected final List<AlbumPhotographSlot> photographSlots = new ArrayList<AlbumPhotographSlot>();
    protected final List<AlbumPlayerInventorySlot> playerInventorySlots = new ArrayList<AlbumPlayerInventorySlot>();
    protected DataSlot currentSpreadIndex = DataSlot.m_39401_();
    @Nullable
    protected Side sideBeingAddedTo = null;
    protected boolean signing;
    protected String title = "";
    protected final Map<Integer, Consumer<Player>> buttonActions = new HashMap<Integer, Consumer<Player>>(){
        {
            this.put(-1, p -> {
                AlbumMenu.this.sideBeingAddedTo = null;
                if (!AlbumMenu.this.m_142621_().m_41619_()) {
                    p.m_150109_().m_150079_(AlbumMenu.this.m_142621_());
                    AlbumMenu.this.m_142503_(ItemStack.f_41583_);
                }
                AlbumMenu.this.updatePlayerInventorySlots();
            });
            this.put(0, p -> {
                AlbumMenu.this.m_6366_((Player)p, -1);
                AlbumMenu.this.setCurrentSpreadIndex(Math.max(0, AlbumMenu.this.getCurrentSpreadIndex() - 1));
            });
            this.put(1, p -> {
                AlbumMenu.this.m_6366_((Player)p, -1);
                AlbumMenu.this.setCurrentSpreadIndex(Math.min((AlbumMenu.this.getPages().size() - 1) / 2, AlbumMenu.this.getCurrentSpreadIndex() + 1));
            });
            this.put(2, p -> AlbumMenu.this.onPhotoButtonPress((Player)p, Side.LEFT));
            this.put(3, p -> AlbumMenu.this.onPhotoButtonPress((Player)p, Side.RIGHT));
            this.put(4, p -> {
                AlbumMenu.this.signing = true;
                AlbumMenu.this.sideBeingAddedTo = null;
            });
            this.put(5, p -> AlbumMenu.this.signAlbum((Player)p));
            this.put(6, p -> {
                AlbumMenu.this.signing = false;
            });
        }
    };

    public AlbumMenu(int containerId, Inventory playerInventory, ItemAndStack<AlbumItem> album, boolean editable) {
        this(Exposure.MenuTypes.ALBUM.get(), containerId, playerInventory, album, editable);
    }

    protected AlbumMenu(MenuType<? extends AbstractContainerMenu> type, int containerId, Inventory playerInventory, ItemAndStack<AlbumItem> album, boolean editable) {
        super(type, containerId);
        this.album = album;
        this.editable = editable;
        ArrayList albumPages = album.getItem().getPages(album.getStack());
        ArrayList arrayList = this.pages = this.isAlbumEditable() ? new ArrayList(albumPages) : albumPages;
        if (this.isAlbumEditable()) {
            while (this.pages.size() < album.getItem().getMaxPages()) {
                this.addEmptyPage();
            }
        }
        this.addPhotographSlots();
        this.addPlayerInventorySlots(playerInventory, 70, 115);
        this.m_38895_(this.currentSpreadIndex);
    }

    private void addPhotographSlots() {
        ItemStack[] photographs = (ItemStack[])this.pages.stream().map(AlbumPage::getPhotographStack).toArray(ItemStack[]::new);
        SimpleContainer container = new SimpleContainer(photographs);
        for (int i = 0; i < container.m_6643_(); ++i) {
            int x = i % 2 == 0 ? 71 : 212;
            int y = 67;
            AlbumPhotographSlot slot = new AlbumPhotographSlot((Container)container, i, x, y);
            this.m_38897_(slot);
            this.photographSlots.add(slot);
        }
        container.m_19164_(c -> {
            List<AlbumPage> pages = this.getPages();
            for (int pageIndex = 0; pageIndex < pages.size(); ++pageIndex) {
                AlbumPage page = pages.get(pageIndex);
                ItemStack stack = container.m_8020_(pageIndex);
                page.setPhotographStack(stack);
            }
            this.updateAlbumStack();
        });
    }

    private void addPlayerInventorySlots(Inventory playerInventory, int x, int y) {
        AlbumPlayerInventorySlot slot;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                slot = new AlbumPlayerInventorySlot((Container)playerInventory, column + row * 9 + 9, x + column * 18, y + row * 18);
                this.m_38897_(slot);
                this.playerInventorySlots.add(slot);
            }
        }
        for (int index = 0; index < 9; ++index) {
            final boolean disabled = index == playerInventory.f_35977_ && playerInventory.m_36056_().m_41720_() instanceof AlbumItem;
            slot = new AlbumPlayerInventorySlot((Container)playerInventory, index, x + index * 18, y + 58){

                public boolean m_8010_(Player player) {
                    return !disabled;
                }

                public boolean m_5857_(ItemStack stack) {
                    return !disabled;
                }
            };
            this.m_38897_(slot);
            this.playerInventorySlots.add(slot);
        }
    }

    protected void updatePlayerInventorySlots() {
        boolean isInAddingPhotographMode = this.isInAddingPhotographMode();
        for (AlbumPlayerInventorySlot slot : this.playerInventorySlots) {
            slot.setActive(isInAddingPhotographMode);
        }
    }

    public boolean isAlbumEditable() {
        return this.editable;
    }

    public boolean isInAddingPhotographMode() {
        return this.getSideBeingAddedTo() != null;
    }

    public boolean isInSigningMode() {
        return this.signing;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String authorName) {
        this.title = authorName;
    }

    public boolean canSignAlbum() {
        for (AlbumPage page : this.getPages()) {
            if (page.getPhotographStack().m_41619_() && !page.getNote().left().map(note -> !note.isEmpty()).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected void signAlbum(Player player) {
        if (!player.m_9236_().f_46443_) {
            return;
        }
        if (!this.canSignAlbum()) {
            throw new IllegalStateException("Cannot sign the album.\n" + Arrays.toString(this.getPages().toArray()));
        }
        Packets.sendToServer(new AlbumSignC2SP(this.title));
    }

    public void updateAlbumStack() {
        List<AlbumPage> pages = this.getPages();
        for (int pageIndex = 0; pageIndex < pages.size(); ++pageIndex) {
            AlbumPage page = pages.get(pageIndex);
            this.album.getItem().setPage(this.album.getStack(), page, pageIndex);
        }
    }

    protected void addEmptyPage() {
        AlbumPage page = this.album.getItem().createEmptyPage();
        this.pages.add(page);
        this.album.getItem().addPage(this.album.getStack(), page);
    }

    public List<AlbumPlayerInventorySlot> getPlayerInventorySlots() {
        return this.playerInventorySlots;
    }

    public List<AlbumPage> getPages() {
        return this.pages;
    }

    public Optional<AlbumPage> getPage(Side side) {
        return this.getPage(this.getCurrentSpreadIndex() * 2 + side.getIndex());
    }

    public Optional<AlbumPage> getPage(int pageIndex) {
        if (pageIndex <= this.getPages().size() - 1) {
            return Optional.ofNullable(this.getPages().get(pageIndex));
        }
        return Optional.empty();
    }

    public Optional<AlbumPhotographSlot> getPhotographSlot(Side side) {
        return this.getPhotographSlot(this.getCurrentSpreadIndex() * 2 + (side == Side.LEFT ? 0 : 1));
    }

    public Optional<AlbumPhotographSlot> getPhotographSlot(int index) {
        if (index >= 0 && index < this.photographSlots.size()) {
            return Optional.ofNullable(this.photographSlots.get(index));
        }
        return Optional.empty();
    }

    public ItemStack getPhotograph(Side side) {
        return this.getPhotographSlot(side).map(Slot::m_7993_).orElse(ItemStack.f_41583_);
    }

    public int getCurrentSpreadIndex() {
        return this.currentSpreadIndex.m_6501_();
    }

    public void setCurrentSpreadIndex(int spreadIndex) {
        this.currentSpreadIndex.m_6422_(spreadIndex);
    }

    @Nullable
    public Side getSideBeingAddedTo() {
        return this.sideBeingAddedTo;
    }

    public boolean m_6366_(Player player, int id) {
        @Nullable Consumer<Player> buttonAction = this.buttonActions.get(id);
        if (buttonAction != null) {
            buttonAction.accept(player);
            return true;
        }
        return false;
    }

    private void onPhotoButtonPress(Player player, Side side) {
        Preconditions.checkArgument((boolean)this.isAlbumEditable(), (Object)("Photo Button should be disabled and hidden when Album is not editable. " + String.valueOf(this.album.getStack())));
        Optional<AlbumPhotographSlot> photographSlot = this.getPhotographSlot(side);
        if (photographSlot.isEmpty()) {
            return;
        }
        AlbumPhotographSlot slot = photographSlot.get();
        if (!slot.m_6657_()) {
            this.sideBeingAddedTo = side;
        } else {
            ItemStack stack = slot.m_7993_();
            if (!player.m_150109_().m_36054_(stack)) {
                player.m_36176_(stack, false);
            }
            slot.m_5852_(ItemStack.f_41583_);
        }
        this.updatePlayerInventorySlots();
    }

    public void m_150399_(int slotId, int button, ClickType clickType, Player player) {
        if (this.sideBeingAddedTo == null || slotId < 0 || slotId >= this.f_38839_.size()) {
            super.m_150399_(slotId, button, clickType, player);
            return;
        }
        Slot slot = (Slot)this.f_38839_.get(slotId);
        ItemStack stack = slot.m_7993_();
        if (button == 0 && slot instanceof AlbumPlayerInventorySlot && stack.m_41720_() instanceof PhotographItem && this.m_142621_().m_41619_()) {
            int pageIndex = this.getCurrentSpreadIndex() * 2 + this.sideBeingAddedTo.getIndex();
            Optional<AlbumPhotographSlot> photographSlot = this.getPhotographSlot(pageIndex);
            if (photographSlot.isEmpty() || !photographSlot.get().m_7993_().m_41619_()) {
                return;
            }
            photographSlot.get().m_5852_(stack);
            slot.m_5852_(ItemStack.f_41583_);
            if (player.m_9236_().f_46443_) {
                player.m_5496_(Exposure.SoundEvents.PHOTOGRAPH_PLACE.get(), 0.8f, 1.1f);
            }
            this.sideBeingAddedTo = null;
            this.updatePlayerInventorySlots();
        } else {
            super.m_150399_(slotId, button, clickType, player);
        }
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return !this.isAlbumEditable() || player.m_21205_().m_41720_() instanceof AlbumItem || player.m_21206_().m_41720_() instanceof AlbumItem;
    }

    public static AlbumMenu fromBuffer(int containerId, Inventory inventory, FriendlyByteBuf buffer) {
        return new AlbumMenu(containerId, inventory, new ItemAndStack<AlbumItem>(buffer.m_130267_()), buffer.readBoolean());
    }
}

