/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data.storage;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.capture.component.ICaptureComponent;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.data.ExposureSize;
import io.github.mortuusars.exposure.data.storage.ExposureExporter;
import io.github.mortuusars.exposure.render.modifiers.ExposurePixelModifiers;
import io.github.mortuusars.exposure.render.modifiers.IPixelModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Date;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public class ClientsideExposureExporter
extends ExposureExporter<ClientsideExposureExporter>
implements ICaptureComponent {
    public ClientsideExposureExporter(String name) {
        super(name);
    }

    @Override
    public boolean save(byte[] mapColorPixels, int width, int height, CompoundTag properties) {
        boolean bl;
        block8: {
            NativeImage image = this.convertToNativeImage(mapColorPixels, width, height, properties);
            try {
                bl = this.save(image, properties);
                if (image == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (image != null) {
                        try {
                            image.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Exposure.LOGGER.error("Cannot convert exposure pixels to NativeImage: {}", (Object)e.toString());
                    return false;
                }
            }
            image.close();
        }
        return bl;
    }

    public boolean save(NativeImage image, CompoundTag properties) {
        try {
            String filepath = this.getFolder() + "/" + (String)(this.getWorldSubfolder() != null ? this.getWorldSubfolder() + "/" : "") + this.getName() + ".png";
            File outputFile = new File(filepath);
            boolean ignored = outputFile.getParentFile().mkdirs();
            image.m_85056_(outputFile);
            if (properties.m_128425_("Timestamp", 4)) {
                long unixSeconds = properties.m_128454_("Timestamp");
                this.trySetFileCreationDate(outputFile.getAbsolutePath(), unixSeconds);
            }
            Exposure.LOGGER.info("Exposure saved: {}", (Object)outputFile);
            return true;
        }
        catch (IOException e) {
            Exposure.LOGGER.error("Failed to save exposure to file: {}", (Object)e.toString());
            return false;
        }
    }

    @Override
    protected void trySetFileCreationDate(String filePath, long creationTimeUnixSeconds) {
        try {
            Date creationDate = Date.from(Instant.ofEpochSecond(creationTimeUnixSeconds));
            BasicFileAttributeView attributes = Files.getFileAttributeView(Paths.get(filePath, new String[0]), BasicFileAttributeView.class, new LinkOption[0]);
            FileTime creationTime = FileTime.fromMillis(creationDate.getTime());
            FileTime modifyTime = FileTime.fromMillis(System.currentTimeMillis());
            attributes.setTimes(modifyTime, modifyTime, creationTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    protected NativeImage convertToNativeImage(byte[] MapColorPixels, int width, int height, CompoundTag properties) {
        NativeImage image = new NativeImage(width, height, false);
        IPixelModifier modifier = this.getModifier();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                FilmType filmType;
                int ABGR = MapColor.m_284315_((int)MapColorPixels[x + y * width]);
                ABGR = modifier.modifyPixel(ABGR);
                if (modifier == ExposurePixelModifiers.NEGATIVE_FILM && (filmType = FilmType.byName(properties.m_128461_("Type"))) != null) {
                    int a = FastColor.ABGR32.m_266503_((int)ABGR);
                    int b = FastColor.ABGR32.m_266247_((int)ABGR);
                    int g = FastColor.ABGR32.m_266446_((int)ABGR);
                    int r = FastColor.ABGR32.m_266313_((int)ABGR);
                    b = b * filmType.frameB / 255;
                    g = g * filmType.frameG / 255;
                    r = r * filmType.frameR / 255;
                    ABGR = FastColor.ABGR32.m_266248_((int)a, (int)b, (int)g, (int)r);
                }
                image.m_84988_(x, y, ABGR);
            }
        }
        if (this.getSize() != ExposureSize.X1) {
            int resultWidth = image.m_84982_() * this.getSize().getMultiplier();
            int resultHeight = image.m_85084_() * this.getSize().getMultiplier();
            NativeImage resized = this.resize(image, 0, 0, image.m_84982_(), image.m_85084_(), resultWidth, resultHeight);
            image.close();
            image = resized;
        }
        return image;
    }

    protected NativeImage resize(NativeImage source, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int resultWidth, int resultHeight) {
        NativeImage result = new NativeImage(source.m_85102_(), resultWidth, resultHeight, false);
        for (int x = 0; x < resultWidth; ++x) {
            float ratioX = (float)x / (float)resultWidth;
            int sourcePosX = (int)((float)sourceX + (float)sourceWidth * ratioX);
            for (int y = 0; y < resultHeight; ++y) {
                float ratioY = (float)y / (float)resultHeight;
                int sourcePosY = (int)((float)sourceY + (float)sourceHeight * ratioY);
                int color = source.m_84985_(sourcePosX, sourcePosY);
                result.m_84988_(x, y, color);
            }
        }
        return result;
    }
}

