/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.pack;

import dev.tomwmth.citreforged.CITReforged;
import dev.tomwmth.citreforged.cit.CIT;
import dev.tomwmth.citreforged.cit.CITCondition;
import dev.tomwmth.citreforged.cit.CITParsingException;
import dev.tomwmth.citreforged.cit.CITRegistry;
import dev.tomwmth.citreforged.cit.CITType;
import dev.tomwmth.citreforged.cit.builtin.conditions.core.FallbackCondition;
import dev.tomwmth.citreforged.cit.builtin.conditions.core.WeightCondition;
import dev.tomwmth.citreforged.pack.GlobalProperties;
import dev.tomwmth.citreforged.pack.format.PropertyGroup;
import dev.tomwmth.citreforged.pack.format.PropertyKey;
import dev.tomwmth.citreforged.pack.format.PropertyValue;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public final class PackParser {
    public static final List<String> ROOTS = List.of("mcpatcher", "optifine", "citresewn");

    private PackParser() {
    }

    public static GlobalProperties loadGlobalProperties(ResourceManager resourceManager, GlobalProperties globalProperties) {
        for (PackResources pack : resourceManager.m_7536_().toList()) {
            for (String namespace : pack.m_5698_(PackType.CLIENT_RESOURCES)) {
                for (String root : ROOTS) {
                    ResourceLocation identifier = new ResourceLocation(namespace, root + "/cit.properties");
                    try {
                        IoSupplier propertiesSupplier = pack.m_214146_(PackType.CLIENT_RESOURCES, identifier);
                        if (propertiesSupplier == null) continue;
                        globalProperties.load(pack.m_5542_(), identifier, (InputStream)propertiesSupplier.m_247737_());
                    }
                    catch (FileNotFoundException propertiesSupplier) {
                    }
                    catch (Exception ex) {
                        CITReforged.logError("Errored while loading global properties: {} from {}", identifier, pack.m_5542_());
                    }
                }
            }
        }
        return globalProperties;
    }

    public static List<CIT<?>> parseCITs(ResourceManager resourceManager) {
        ArrayList cits = new ArrayList();
        for (String root : ROOTS) {
            for (Map.Entry entry : resourceManager.m_214159_(root + "/cit", s -> s.m_135815_().endsWith(".properties")).entrySet()) {
                String packName = null;
                ResourceLocation key = (ResourceLocation)entry.getKey();
                Resource val = (Resource)entry.getValue();
                try {
                    packName = val.m_215506_();
                    cits.add(PackParser.parseCIT(PropertyGroup.tryParseGroup(packName, key, val.m_215507_()), resourceManager));
                }
                catch (CITParsingException ex) {
                    CITReforged.logError("Errored while parsing CIT", ex);
                }
                catch (Exception ex) {
                    CITReforged.logError("Errored while loading CIT: {}{}", key, packName == null ? "" : " from " + packName, ex);
                }
            }
        }
        return cits;
    }

    public static CIT<?> parseCIT(PropertyGroup properties, ResourceManager resourceManager) throws CITParsingException {
        CITType citType = CITRegistry.parseType(properties);
        ArrayList<CITCondition> conditions = new ArrayList<CITCondition>();
        Set<PropertyKey> ignoredProperties = citType.typeProperties();
        for (Map.Entry<PropertyKey, Set<PropertyValue>> entry : properties.properties.entrySet()) {
            if (entry.getKey().path().equals("type") && entry.getKey().namespace().equals("citresewn") || ignoredProperties.contains(entry.getKey())) continue;
            for (PropertyValue propertyValue : entry.getValue()) {
                conditions.add(CITRegistry.parseCondition(entry.getKey(), propertyValue, properties));
            }
        }
        for (CITCondition condition2 : new ArrayList(conditions)) {
            if (condition2 == null) continue;
            for (Class clazz : condition2.siblingConditions()) {
                conditions.replaceAll(siblingCondition -> siblingCondition != null && siblingConditionType == siblingCondition.getClass() ? condition2.modifySibling(siblingCondition) : siblingCondition);
            }
        }
        WeightCondition weight = new WeightCondition();
        FallbackCondition fallback = new FallbackCondition();
        conditions.removeIf(condition -> {
            if (condition instanceof WeightCondition) {
                WeightCondition weightCondition = (WeightCondition)condition;
                weight.setWeight(weightCondition.getWeight());
                return true;
            }
            if (condition instanceof FallbackCondition) {
                FallbackCondition fallbackCondition = (FallbackCondition)condition;
                fallback.setFallback(fallbackCondition.getFallback());
                return true;
            }
            return condition == null;
        });
        citType.load(conditions, properties, resourceManager);
        return new CIT<CITType>(properties.identifier, properties.packName, citType, conditions.toArray(new CITCondition[0]), weight.getWeight(), fallback.getFallback());
    }
}

