/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.pack;

import dev.tomwmth.citreforged.CITReforged;
import dev.tomwmth.citreforged.CITRegistrarImpl;
import dev.tomwmth.citreforged.pack.format.PropertyGroup;
import dev.tomwmth.citreforged.pack.format.PropertyKey;
import dev.tomwmth.citreforged.pack.format.PropertyValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;

public class GlobalProperties
extends PropertyGroup {
    public GlobalProperties() {
        super("global_properties", new ResourceLocation("citresewn", "global_properties"));
    }

    @Override
    public String getExtension() {
        return ".properties";
    }

    @Override
    public PropertyGroup load(String packName, ResourceLocation identifier, InputStream is) throws IOException, ResourceLocationException {
        PropertyGroup group = PropertyGroup.tryParseGroup(packName, identifier, is);
        if (group != null) {
            for (Map.Entry<PropertyKey, Set<PropertyValue>> entry : group.properties.entrySet()) {
                this.properties.computeIfAbsent(entry.getKey(), key -> new LinkedHashSet()).addAll((Collection)entry.getValue());
            }
        }
        return this;
    }

    public void callHandlers() {
        CITRegistrarImpl.getGlobalProperties().forEach((namespace, globalProperties) -> {
            for (Map.Entry entry : this.properties.entrySet()) {
                if (!((PropertyKey)entry.getKey()).namespace().equals(namespace)) continue;
                PropertyValue lastValue = null;
                Iterator iterator = ((Set)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    PropertyValue value;
                    lastValue = value = (PropertyValue)iterator.next();
                }
                try {
                    globalProperties.globalProperty(((PropertyKey)entry.getKey()).path(), lastValue);
                }
                catch (Exception ex) {
                    if (lastValue == null) {
                        CITReforged.LOGGER.error("Errored while disposing global properties");
                        continue;
                    }
                    CITReforged.LOGGER.error("Errored while parsing global properties: Line " + lastValue.position() + " of " + lastValue.propertiesIdentifier() + " in " + lastValue.packName());
                }
            }
        });
    }
}

