/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.defaults.cit.conditions;

import dev.tomwmth.citreforged.api.CITConditionContainer;
import dev.tomwmth.citreforged.cit.CITContext;
import dev.tomwmth.citreforged.cit.CITParsingException;
import dev.tomwmth.citreforged.cit.builtin.conditions.IdentifierCondition;
import dev.tomwmth.citreforged.cit.builtin.conditions.ListCondition;
import dev.tomwmth.citreforged.pack.format.PropertyGroup;
import dev.tomwmth.citreforged.pack.format.PropertyValue;
import java.util.LinkedHashSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ConditionItems
extends ListCondition<ItemCondition> {
    public static final CITConditionContainer<ConditionItems> CONTAINER = new CITConditionContainer<ConditionItems>(ConditionItems.class, ConditionItems::new, "items", "matchItems");
    public Item[] items = new Item[0];

    public ConditionItems() {
        super(ItemCondition.class, ItemCondition::new);
    }

    public ConditionItems(Item ... items) {
        this();
        this.items = items;
    }

    @Override
    public void load(PropertyValue value, PropertyGroup properties) throws CITParsingException {
        super.load(value, properties);
        LinkedHashSet<Item> items = new LinkedHashSet<Item>();
        for (ItemCondition itemCondition : (ItemCondition[])this.conditions) {
            items.add(itemCondition.item);
        }
        this.items = items.toArray(new Item[0]);
    }

    @Override
    public boolean test(CITContext context) {
        for (Item item : this.items) {
            if (context.stack.m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    protected static class ItemCondition
    extends IdentifierCondition {
        public Item item = null;

        protected ItemCondition() {
        }

        @Override
        public void load(PropertyValue value, PropertyGroup properties) throws CITParsingException {
            super.load(value, properties);
            if (BuiltInRegistries.f_257033_.m_7804_(this.value)) {
                this.item = (Item)BuiltInRegistries.f_257033_.m_7745_(this.value);
            } else {
                this.item = null;
                this.warn(this.value + " is not in the item registry", value, properties);
            }
        }

        @Override
        protected ResourceLocation getValue(CITContext context) {
            return this.value;
        }
    }
}

