/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.defaults.cit.conditions;

import dev.tomwmth.citreforged.api.CITConditionContainer;
import dev.tomwmth.citreforged.cit.CITCondition;
import dev.tomwmth.citreforged.cit.CITContext;
import dev.tomwmth.citreforged.cit.CITParsingException;
import dev.tomwmth.citreforged.cit.builtin.conditions.IdentifierCondition;
import dev.tomwmth.citreforged.cit.builtin.conditions.ListCondition;
import dev.tomwmth.citreforged.defaults.cit.conditions.ConditionEnchantmentLevels;
import dev.tomwmth.citreforged.pack.format.PropertyGroup;
import dev.tomwmth.citreforged.pack.format.PropertyValue;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public class ConditionEnchantments
extends ListCondition<EnchantmentCondition> {
    public static final CITConditionContainer<ConditionEnchantments> CONTAINER = new CITConditionContainer<ConditionEnchantments>(ConditionEnchantments.class, ConditionEnchantments::new, "enchantments", "enchantmentIDs");

    public ConditionEnchantments() {
        super(EnchantmentCondition.class, EnchantmentCondition::new);
    }

    public ResourceLocation[] getEnchantments() {
        ResourceLocation[] enchantments = new ResourceLocation[((EnchantmentCondition[])this.conditions).length];
        for (int i = 0; i < ((EnchantmentCondition[])this.conditions).length; ++i) {
            enchantments[i] = ((EnchantmentCondition[])this.conditions)[i].getValue(null);
        }
        return enchantments;
    }

    @Override
    public Set<Class<? extends CITCondition>> siblingConditions() {
        return Set.of(ConditionEnchantmentLevels.class);
    }

    protected static class EnchantmentCondition
    extends IdentifierCondition {
        protected EnchantmentCondition() {
        }

        @Override
        public void load(PropertyValue value, PropertyGroup properties) throws CITParsingException {
            super.load(value, properties);
            if (!BuiltInRegistries.f_256876_.m_7804_(this.value)) {
                this.warn(this.value + " is not in the enchantment registry", value, properties);
            }
        }

        @Override
        public boolean test(CITContext context) {
            return context.enchantments().containsKey(this.value);
        }

        @Override
        protected ResourceLocation getValue(CITContext context) {
            return this.value;
        }
    }
}

