/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.cit.builtin.conditions.core;

import dev.tomwmth.citreforged.api.CITConditionContainer;
import dev.tomwmth.citreforged.api.CITGlobalProperties;
import dev.tomwmth.citreforged.cit.CIT;
import dev.tomwmth.citreforged.cit.builtin.conditions.IdentifierCondition;
import dev.tomwmth.citreforged.pack.format.PropertyValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class FallbackCondition
extends IdentifierCondition {
    public static final CITGlobalProperties PROPS_CONTAINER = FallbackCondition::globalProperty;
    public static final CITConditionContainer<FallbackCondition> COND_CONTAINER = new CITConditionContainer<FallbackCondition>(FallbackCondition.class, FallbackCondition::new, "cit_fallback", "citFallback");
    private static boolean fallbackCITResewnRoot = false;

    public FallbackCondition() {
        this.value = null;
    }

    public ResourceLocation getFallback() {
        return this.value;
    }

    public void setFallback(ResourceLocation value) {
        this.value = value;
    }

    public static void globalProperty(String key, PropertyValue value) throws Exception {
        if (key.equals("root_fallback")) {
            fallbackCITResewnRoot = value != null && Boolean.parseBoolean(value.value());
        }
    }

    public static void apply(List<CIT<?>> cits) {
        HashMap<String, Set> removePacks = new HashMap<String, Set>();
        for (CIT<?> cit2 : cits) {
            Set remove = removePacks.computeIfAbsent(cit2.packName, s -> new HashSet());
            if (cit2.fallback == null) {
                if (!fallbackCITResewnRoot || !cit2.propertiesIdentifier.m_135815_().startsWith("citresewn/")) continue;
                String subPath = cit2.propertiesIdentifier.m_135815_().substring(10);
                remove.add(new ResourceLocation(cit2.propertiesIdentifier.m_135827_(), "optifine/" + subPath));
                remove.add(new ResourceLocation(cit2.propertiesIdentifier.m_135827_(), "mcpatcher/" + subPath));
                continue;
            }
            remove.add(cit2.fallback);
        }
        cits.removeIf(cit -> {
            Set remove = (Set)removePacks.get(cit.packName);
            return remove != null && remove.contains(cit.propertiesIdentifier);
        });
    }
}

