/*
 * Decompiled with CFR 0.152.
 */
package dev.tomwmth.citreforged.cit.builtin.conditions;

import dev.tomwmth.citreforged.cit.CITCondition;
import dev.tomwmth.citreforged.cit.CITContext;
import dev.tomwmth.citreforged.cit.CITParsingException;
import dev.tomwmth.citreforged.pack.format.PropertyGroup;
import dev.tomwmth.citreforged.pack.format.PropertyValue;

public abstract class IntegerCondition
extends CITCondition {
    protected final boolean supportsRanges;
    protected final boolean supportsNegatives;
    protected final boolean supportsPercentages;
    protected int min;
    protected int max;
    protected boolean range = false;
    protected boolean percentage = false;

    protected IntegerCondition(boolean supportsRanges, boolean supportsNegatives, boolean supportsPercentages) {
        this.supportsRanges = supportsRanges;
        this.supportsNegatives = supportsNegatives;
        this.supportsPercentages = supportsPercentages;
    }

    protected int getValue(CITContext context) {
        throw new AssertionError((Object)"Not implemented by this condition");
    }

    protected int getPercentageTotalValue(CITContext context) {
        throw new AssertionError((Object)"Not implemented by this condition");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void load(PropertyValue value, PropertyGroup properties) throws CITParsingException {
        String strValue = value.value();
        if (this.supportsPercentages && (this.percentage = strValue.contains("%"))) {
            strValue = strValue.replace("%", "");
        }
        try {
            block33: {
                block31: {
                    block32: {
                        this.range = this.supportsRanges;
                        if (!this.range) break block31;
                        if (!this.supportsNegatives) break block32;
                        switch (strValue.length() - strValue.replace("-", "").length()) {
                            case 0: {
                                this.range = false;
                                this.min = Integer.parseInt(strValue);
                                break block33;
                            }
                            case 1: {
                                if (strValue.startsWith("-")) {
                                    this.range = false;
                                    this.min = Integer.parseInt(strValue);
                                } else if (strValue.endsWith("-")) {
                                    this.min = Integer.parseInt(strValue.substring(0, strValue.length() - 1));
                                    this.max = Integer.MAX_VALUE;
                                } else {
                                    String[] split = strValue.split("-");
                                    this.min = Integer.parseInt(split[0]);
                                    this.max = Integer.parseInt(split[1]);
                                }
                                break block33;
                            }
                            case 2: {
                                if (strValue.startsWith("--")) {
                                    this.min = Integer.MIN_VALUE;
                                    this.max = Integer.parseInt(strValue.substring(1));
                                } else if (strValue.startsWith("-") && strValue.endsWith("-")) {
                                    this.min = Integer.parseInt(strValue.substring(0, strValue.length() - 1));
                                    this.max = Integer.MAX_VALUE;
                                } else {
                                    if (!strValue.startsWith("-") || strValue.endsWith("-") || strValue.contains("--")) throw new CITParsingException("Could not parse range", properties, value.position());
                                    int lastDash = strValue.lastIndexOf(45);
                                    this.min = Integer.parseInt(strValue.substring(0, lastDash));
                                    this.max = Integer.parseInt(strValue.substring(lastDash + 1));
                                }
                                break block33;
                            }
                            case 3: {
                                if (strValue.contains("---") || !strValue.startsWith("-")) throw new CITParsingException("Could not parse range", properties, value.position());
                                String[] split = strValue.split("--");
                                if (split.length != 2 || split[0].isEmpty() || split[1].isEmpty()) {
                                    throw new CITParsingException("Could not parse range", properties, value.position());
                                }
                                this.min = Integer.parseInt(split[0]);
                                this.max = -Integer.parseInt(split[1]);
                                break block33;
                            }
                            default: {
                                throw new CITParsingException("Could not parse range", properties, value.position());
                            }
                        }
                    }
                    this.range = strValue.contains("-");
                    if (this.range) {
                        if (strValue.contains("--")) {
                            throw new CITParsingException("Could not parse range", properties, value.position());
                        }
                        String[] split = strValue.split("-");
                        switch (split.length) {
                            case 1: {
                                this.min = Integer.parseInt(split[0]);
                                this.max = Integer.MAX_VALUE;
                                break;
                            }
                            case 2: {
                                if (strValue.endsWith("-")) {
                                    throw new CITParsingException("Could not parse range", properties, value.position());
                                }
                                this.min = split[0].isEmpty() ? Integer.MIN_VALUE : Integer.parseInt(split[0]);
                                this.max = split[1].isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(split[1]);
                                break;
                            }
                            default: {
                                throw new CITParsingException("Could not parse range", properties, value.position());
                            }
                        }
                    } else {
                        this.min = Integer.parseInt(strValue);
                    }
                    break block33;
                }
                this.min = Integer.parseInt(strValue);
                if (!this.supportsNegatives && this.min < 0) {
                    throw new CITParsingException("Negatives are not allowed", properties, value.position());
                }
            }
            if (!this.range) return;
            if (this.min == this.max) {
                this.range = false;
                return;
            } else {
                if (this.min <= this.max) return;
                throw new CITParsingException("Could not parse range", properties, value.position());
            }
        }
        catch (Exception e) {
            CITParsingException citE;
            throw e instanceof CITParsingException ? (citE = (CITParsingException)e) : new CITParsingException("Could not parse integer", properties, value.position(), e);
        }
    }

    @Override
    public boolean test(CITContext context) {
        int value = this.getValue(context);
        if (this.percentage) {
            double percentValue = 100.0 * (double)value / (double)this.getPercentageTotalValue(context);
            return this.range ? (double)this.min <= percentValue && percentValue <= (double)this.max : percentValue == (double)this.min;
        }
        return this.range ? this.min <= value && value <= this.max : value == this.min;
    }
}

