/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import org.jetbrains.annotations.Nullable;

public class ModSharedVariables {
    private static final Map<String, Supplier<String>> STRINGS = new HashMap<String, Supplier<String>>();
    private static final Map<String, Supplier<Double>> DOUBLES = new HashMap<String, Supplier<Double>>();
    private static final Map<String, Supplier<Boolean>> BOOL = new HashMap<String, Supplier<Boolean>>();
    private static final Map<String, Function<Object, Object>> FUNCTIONS = new HashMap<String, Function<Object, Object>>();

    public static void registerString(String name, Supplier<String> supp) {
        if (STRINGS.put(name, supp) != null && PlatHelper.isDev()) {
            throw new AssertionError((Object)("There already exist a shared variable with name " + name));
        }
    }

    public static void registerDouble(String name, Supplier<Double> supp) {
        if (DOUBLES.put(name, supp) != null && PlatHelper.isDev()) {
            throw new AssertionError((Object)("There already exist a shared variable with name " + name));
        }
    }

    public static void registerBool(String name, Supplier<Boolean> supp) {
        if (BOOL.put(name, supp) != null && PlatHelper.isDev()) {
            throw new AssertionError((Object)("There already exist a shared variable with name " + name));
        }
    }

    public static void registerFunction(String name, Function<Object, Object> supp) {
        if (FUNCTIONS.put(name, supp) != null && PlatHelper.isDev()) {
            throw new AssertionError((Object)("There already exist a shared variable with name " + name));
        }
    }

    @Nullable
    public static Double getDouble(String name) {
        Supplier<Double> sup = DOUBLES.get(name);
        return sup == null ? null : sup.get();
    }

    @Nullable
    public static Boolean getBool(String name) {
        Supplier<Boolean> sup = BOOL.get(name);
        return sup == null ? null : sup.get();
    }

    @Nullable
    public static String getString(String name) {
        Supplier<String> sup = STRINGS.get(name);
        return sup == null ? null : sup.get();
    }

    @Nullable
    public static Object invokeFunction(String name) {
        Function<Object, Object> sup = FUNCTIONS.get(name);
        return sup == null ? null : sup.apply(name);
    }
}

