/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.entity;

import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.satisfy.brewery.entity.BeerElementalAttackEntity;

public class BeerElementalEntity
extends Monster {
    private float allowedHeightOffset = 0.5f;
    private int nextHeightOffsetChangeTick;

    public BeerElementalEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 8;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)1.0f, (float)2.0f);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(3, (Goal)new BeerElementalAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8107_() {
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.m_9236_().f_46443_) {
            if (this.f_19796_.m_188503_(24) == 0 && !this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123768_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        LivingEntity target;
        --this.nextHeightOffsetChangeTick;
        if (this.nextHeightOffsetChangeTick <= 0) {
            this.nextHeightOffsetChangeTick = 100;
            this.allowedHeightOffset = (float)this.f_19796_.m_216328_(0.5, 6.891);
        }
        if ((target = this.m_5448_()) != null && target.m_20188_() > this.m_20188_() + (double)this.allowedHeightOffset && this.m_6779_(target)) {
            Vec3 velocity = this.m_20184_();
            velocity = velocity.m_82520_(0.0, (0.3 - velocity.f_82480_) * 0.3, 0.0);
            this.m_20256_(velocity);
            this.f_19812_ = true;
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 8.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_144064_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)DoApiSoundEventRegistry.BEER_ELEMENTAL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DoApiSoundEventRegistry.BEER_ELEMENTAL_DEATH.get();
    }

    public float m_213856_() {
        return 1.0f;
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    private static class BeerElementalAttackGoal
    extends Goal {
        private final BeerElementalEntity elemental;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public BeerElementalAttackGoal(BeerElementalEntity elemental) {
            this.elemental = elemental;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.elemental.m_5448_();
            return target != null && target.m_6084_() && this.elemental.m_6779_(target);
        }

        public void m_8056_() {
            this.attackStep = 0;
        }

        public void m_8041_() {
            this.lastSeen = 0;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity target = this.elemental.m_5448_();
            if (target == null) {
                return;
            }
            boolean canSee = this.elemental.m_21574_().m_148306_((Entity)target);
            this.lastSeen = canSee ? 0 : this.lastSeen + 1;
            double dist = this.elemental.m_20280_((Entity)target);
            double range = this.getFollowDistance() * this.getFollowDistance();
            if (dist < 4.0) {
                if (!canSee) {
                    return;
                }
                if ((double)this.attackTime <= 0.0) {
                    this.attackTime = 20;
                    this.elemental.m_7327_((Entity)target);
                }
                this.elemental.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
            } else if (dist < range && canSee) {
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 60;
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 0;
                    }
                    if (this.attackStep > 1) {
                        if (!this.elemental.m_20067_()) {
                            this.elemental.m_5496_((SoundEvent)DoApiSoundEventRegistry.BEER_ELEMENTAL_ATTACK.get(), 1.0f, 1.0f);
                        }
                        double dX = target.m_20185_() - this.elemental.m_20185_();
                        double dY = target.m_20227_(0.5) - this.elemental.m_20227_(0.5);
                        double dZ = target.m_20189_() - this.elemental.m_20189_();
                        double f = Math.sqrt(Math.sqrt(dist)) * 0.5;
                        for (int i = 0; i < 1; ++i) {
                            BeerElementalAttackEntity attack = new BeerElementalAttackEntity(this.elemental.m_9236_(), (LivingEntity)this.elemental, this.elemental.m_217043_().m_216328_(dX, 2.297 * f), dY, this.elemental.m_217043_().m_216328_(dZ, 2.297 * f));
                            attack.m_6034_(attack.m_20185_(), this.elemental.m_20227_(0.5) + 0.5, attack.m_20189_());
                            this.elemental.m_9236_().m_7967_((Entity)attack);
                        }
                    }
                }
                this.elemental.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
            } else if (this.lastSeen < 5) {
                this.elemental.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
            }
            super.m_8037_();
        }

        private double getFollowDistance() {
            return this.elemental.m_21133_(Attributes.f_22277_);
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

