/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block.brewingstation;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.brewery.block.entity.BrewstationBlockEntity;
import net.satisfy.brewery.block.property.BrewMaterial;
import net.satisfy.brewery.registry.BlockStateRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewingstationBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<BrewMaterial> MATERIAL = BlockStateRegistry.MATERIAL;

    public BrewingstationBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_(this.m_49966_());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(getter, pos, state);
        BrewstationBlockEntity blockEntity = this.getController(pos, getter);
        if (blockEntity != null) {
            return blockEntity.m_58900_().m_60734_().m_7397_(getter, pos, state);
        }
        return stack;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MATERIAL, f_54117_});
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BrewstationBlockEntity brewstationEntity = this.getController(pos, level);
        if (brewstationEntity != null) {
            brewstationEntity.getComponents().stream().filter(componentPos -> !componentPos.equals((Object)pos)).forEach(componentPos -> level.m_7471_(componentPos, false));
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nullable
    protected BrewstationBlockEntity getController(BlockPos centerPos, Level level) {
        return this.findController(centerPos, level);
    }

    @Nullable
    protected BrewstationBlockEntity getController(BlockPos centerPos, BlockGetter getter) {
        return this.findController(centerPos, getter);
    }

    private <T extends BlockGetter> BrewstationBlockEntity findController(BlockPos centerPos, T blockGetter) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                BrewstationBlockEntity brewstationEntity;
                BlockEntity blockEntity = blockGetter.m_7702_(centerPos.m_7918_(x, 0, y));
                if (!(blockEntity instanceof BrewstationBlockEntity) || !(brewstationEntity = (BrewstationBlockEntity)blockEntity).isPartOf(centerPos)) continue;
                return brewstationEntity;
            }
        }
        return null;
    }
}

