/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block.brew_event;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.satisfy.brewery.block.brew_event.BrewEvent;
import net.satisfy.brewery.block.brew_event.KettleEvent;
import net.satisfy.brewery.block.brew_event.OvenEvent;
import net.satisfy.brewery.block.brew_event.TimerEvent;
import net.satisfy.brewery.block.brew_event.WhistleEvent;
import net.satisfy.brewery.util.BreweryIdentifier;
import org.jetbrains.annotations.Nullable;

public class BrewEvents {
    public static final Map<ResourceLocation, Supplier<BrewEvent>> BREW_EVENTS = new HashMap<ResourceLocation, Supplier<BrewEvent>>();
    public static final ResourceLocation KETTLE_EVENT = BrewEvents.registerBrewEvent("kettle", KettleEvent::new);
    public static final ResourceLocation OVEN_EVENT = BrewEvents.registerBrewEvent("oven", OvenEvent::new);
    public static final ResourceLocation WHISTLE_EVENT = BrewEvents.registerBrewEvent("whistle", WhistleEvent::new);
    public static final ResourceLocation TIMER_EVENT = BrewEvents.registerBrewEvent("timer", TimerEvent::new);

    public static void loadClass() {
    }

    public static ResourceLocation registerBrewEvent(String id, Supplier<BrewEvent> brewEventSupplier) {
        BreweryIdentifier resourceLocation = new BreweryIdentifier(id);
        BREW_EVENTS.put(resourceLocation, brewEventSupplier);
        return resourceLocation;
    }

    public static List<ResourceLocation> toLocations(Collection<BrewEvent> events) {
        return events.stream().map(BrewEvents::getId).collect(Collectors.toList());
    }

    public static List<BrewEvent> toEvents(List<Supplier<BrewEvent>> events) {
        return events.stream().map(Supplier::get).collect(Collectors.toList());
    }

    @Nullable
    public static ResourceLocation getId(BrewEvent event) {
        if (event == null) {
            return null;
        }
        for (ResourceLocation location : BREW_EVENTS.keySet()) {
            BrewEvent brewEvent = BREW_EVENTS.get(location).get();
            if (event.getClass() != brewEvent.getClass()) continue;
            return location;
        }
        return null;
    }

    @Nullable
    public static Supplier<BrewEvent> byId(ResourceLocation id) {
        return BREW_EVENTS.get(id);
    }
}

