/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.core.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.core.LatexProcessingUnitConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class LatexProcessingUnitTile
extends IndustrialProcessingTile<LatexProcessingUnitTile> {
    private static int AMOUNT_LATEX = 750;
    private static int AMOUNT_WATER = 500;
    @Save
    private SidedFluidTankComponent<LatexProcessingUnitTile> latex = (SidedFluidTankComponent)new SidedFluidTankComponent("latex", LatexProcessingUnitConfig.maxLatexTankSize, 29, 20, 0).setColor(DyeColor.LIGHT_GRAY).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().m_6212_((Fluid)ModuleCore.LATEX.getSourceFluid().get()));
    @Save
    private SidedFluidTankComponent<LatexProcessingUnitTile> water;
    @Save
    private SidedInventoryComponent<LatexProcessingUnitTile> output;

    public LatexProcessingUnitTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleCore.LATEX_PROCESSING, 73, 40, blockPos, blockState);
        this.addTank(this.latex);
        this.water = (SidedFluidTankComponent)new SidedFluidTankComponent("water", LatexProcessingUnitConfig.maxWaterTankSize, 48, 20, 1).setColor(DyeColor.BLUE).setComponentHarness((IComponentHarness)this).setValidator(fluidStack -> fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76193_));
        this.addTank(this.water);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 104, 22, 9, 2).setColor(DyeColor.ORANGE).setRange(3, 3).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
    }

    @Override
    public boolean canIncrease() {
        return this.latex.getFluidAmount() >= AMOUNT_LATEX && this.water.getFluidAmount() >= AMOUNT_WATER && ItemHandlerHelper.insertItem(this.output, (ItemStack)new ItemStack((ItemLike)ModuleCore.DRY_RUBBER.get()), (boolean)true).m_41619_();
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            this.latex.drain(AMOUNT_LATEX, IFluidHandler.FluidAction.EXECUTE);
            this.water.drain(AMOUNT_WATER, IFluidHandler.FluidAction.EXECUTE);
            ItemHandlerHelper.insertItem(this.output, (ItemStack)new ItemStack((ItemLike)ModuleCore.DRY_RUBBER.get()), (boolean)false);
        };
    }

    protected EnergyStorageComponent<LatexProcessingUnitTile> createEnergyStorage() {
        return new EnergyStorageComponent(LatexProcessingUnitConfig.maxStoredPower, 10, 20);
    }

    @Override
    protected int getTickPower() {
        return LatexProcessingUnitConfig.powerPerTick;
    }

    @Nonnull
    public LatexProcessingUnitTile getSelf() {
        return this;
    }
}

