/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.minecraft.framedhopper.utils;

import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerUtils {
    protected ItemHandlerUtils() {
    }

    public static boolean isItemHandler(BlockEntity blockEntity, Direction direction) {
        Capability itemHandlerCapability = ForgeCapabilities.ITEM_HANDLER;
        return blockEntity != null && direction != null && itemHandlerCapability != null && blockEntity.getCapability(itemHandlerCapability, direction).isPresent();
    }

    public static IItemHandler getItemHandler(BlockEntity blockEntity, Direction direction) {
        Optional capability;
        if (!ItemHandlerUtils.isItemHandler(blockEntity, direction)) {
            return null;
        }
        Capability itemHandlerCapability = ForgeCapabilities.ITEM_HANDLER;
        if (itemHandlerCapability != null && (capability = blockEntity.getCapability(itemHandlerCapability, direction).resolve()).isPresent()) {
            return (IItemHandler)capability.get();
        }
        return null;
    }
}

